package com.fpt.okhttp.callback;

import android.text.TextUtils;

import com.fpt.okhttp.exception.OkHttpException;
import com.fpt.okhttp.listener.DisposeDataListener;

/**
 * <pre>
 *   @author  : lucien.feng
 *   e-mail  : fengfei0205@gmail.com
 *   time    : 2018/08/15 10:28
 *   desc    : 带加载框的网络请求回调
 *   version : 1.0.4
 * </pre>
 */
public abstract class NetCallBack extends JsonCallback implements DisposeDataListener {

    /**
     * 默认构造
     */
    public NetCallBack() {
        setListener(this);
        isShowDialog(true);
    }

    /**
     * 是否关闭联网对话框
     *
     * @param isShow 是否关闭
     */
    public abstract void isShowDialog(boolean isShow);

    @Override
    public void onSuccess(String json) {
        isShowDialog(false);
        if (TextUtils.isEmpty(json)) {
            onFailed(new OkHttpException(NETWORK_ERROR, EMPTY_MSG));
        } else {
            onSucceed(json);
        }
    }

    @Override
    public void onFailure(OkHttpException exception) {
        isShowDialog(false);
        onFailed(exception);
    }

    /**
     * 成功回调
     *
     * @param json 信息
     */
    public abstract void onSucceed(String json);

    /**
     * 错误回调
     *
     * @param exception 错误信息
     */
    public abstract void onFailed(OkHttpException exception);

}
