/*
 * Decompiled with CFR 0.152.
 */
package com.fpt.okhttp.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Handler;
import android.os.Looper;
import com.blankj.utilcode.util.NetworkUtils;

public class NetworkChangedReceiver
extends BroadcastReceiver {
    private Context mContext;
    private OnNetworkStatusListener listener;
    private static String mHost = null;

    public NetworkChangedReceiver(Context context) {
        this.register(context);
        this.setHost(null);
    }

    public NetworkChangedReceiver(Context context, String host) {
        this.register(context);
        this.setHost(host);
    }

    public void onReceive(Context context, Intent intent) {
        if (intent.getAction() == "android.net.conn.CONNECTIVITY_CHANGE") {
            boolean isConnected = NetworkUtils.isConnected();
            if (isConnected) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        final boolean ping = NetworkUtils.isAvailableByPing((String)mHost);
                        new Handler(Looper.getMainLooper()).post(new Runnable(){

                            @Override
                            public void run() {
                                if (NetworkChangedReceiver.this.listener != null) {
                                    NetworkChangedReceiver.this.listener.onNetworkStatus(ping);
                                }
                            }
                        });
                    }
                }).start();
            } else if (this.listener != null) {
                this.listener.onNetworkStatus(false);
            }
        }
    }

    private void register(Context context) {
        this.mContext = context;
        IntentFilter filter = new IntentFilter();
        filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
        this.mContext.registerReceiver((BroadcastReceiver)this, filter);
    }

    public void setHost(String mHost) {
        NetworkChangedReceiver.mHost = mHost;
    }

    public void unregister() {
        this.mContext.unregisterReceiver((BroadcastReceiver)this);
    }

    public void setOnNetworkStatusListener(OnNetworkStatusListener listener) {
        this.listener = listener;
    }

    public static interface OnNetworkStatusListener {
        public void onNetworkStatus(boolean var1);
    }
}

