/*
 * Decompiled with CFR 0.152.
 */
package com.fpt.okhttp.progress;

import android.support.annotation.Nullable;
import com.fpt.okhttp.listener.OnProgressListener;
import com.fpt.okhttp.progress.ProgressOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public class UploadRequestBody
extends RequestBody {
    private final RequestBody requestBody;
    private OnProgressListener progressListener;

    public UploadRequestBody(RequestBody requestBody, OnProgressListener listener) {
        this.requestBody = requestBody;
        this.progressListener = listener;
    }

    @Nullable
    public MediaType contentType() {
        return this.requestBody.contentType();
    }

    public long contentLength() throws IOException {
        return this.requestBody.contentLength();
    }

    public void writeTo(BufferedSink sink) throws IOException {
        if (this.progressListener == null) {
            this.requestBody.writeTo(sink);
            return;
        }
        ProgressOutputStream progressOutputStream = new ProgressOutputStream(sink.outputStream(), this.progressListener, this.contentLength());
        BufferedSink progressSink = Okio.buffer((Sink)Okio.sink((OutputStream)progressOutputStream));
        this.requestBody.writeTo(progressSink);
        progressSink.flush();
    }
}

