/*
 * Decompiled with CFR 0.152.
 */
package com.fpt.okhttp.callback;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.fpt.okhttp.exception.OkHttpException;
import com.fpt.okhttp.listener.DisposeDataListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;

public class JsonCallback
implements Callback {
    protected final int NETWORK_ERROR = -1;
    protected final String EMPTY_MSG = "\u53d1\u751f\u672a\u77e5\u9519\u8bef!";
    private Handler mHandler;
    private DisposeDataListener mListener;
    private int mErrorCode;
    private String mErrorMsg;

    public JsonCallback() {
        this(null);
    }

    public JsonCallback(DisposeDataListener mListener) {
        this.mListener = mListener;
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public DisposeDataListener getListener() {
        return this.mListener;
    }

    public void setListener(DisposeDataListener mListener) {
        this.mListener = mListener;
    }

    public void onFailure(Call call, IOException e) {
        this.mErrorCode = -1;
        this.mErrorMsg = e instanceof ConnectException || e instanceof UnknownHostException ? "\u60a8\u7684\u7f51\u7edc\u4e0d\u592a\u7ed9\u529b" : "\u672a\u77e5\u9519\u8bef";
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                JsonCallback.this.mListener.onFailure(new OkHttpException(JsonCallback.this.mErrorCode, JsonCallback.this.mErrorMsg));
            }
        });
    }

    public void onResponse(Call call, Response response) throws IOException {
        final String result = response.body().string();
        final boolean isSuccess = response.isSuccessful();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (!TextUtils.isEmpty((CharSequence)result) && isSuccess) {
                    JsonCallback.this.mListener.onSuccess(result);
                } else {
                    JsonCallback.this.mListener.onFailure(new OkHttpException(-1, "\u53d1\u751f\u672a\u77e5\u9519\u8bef!"));
                }
            }
        });
    }
}

