/*
 * Decompiled with CFR 0.152.
 */
package com.fpt.okhttp.progress;

import com.fpt.okhttp.listener.OnProgressListener;
import java.io.IOException;
import java.io.InputStream;

public class ProgressInputStream
extends InputStream {
    private final InputStream stream;
    private final OnProgressListener listener;
    private long total;
    private long totalRead;

    ProgressInputStream(InputStream stream, OnProgressListener listener, long total) {
        this.stream = stream;
        this.listener = listener;
        this.total = total;
    }

    @Override
    public int read() throws IOException {
        int read = this.stream.read();
        if (this.total < 0L) {
            this.listener.onProgressChanged(-1L, -1L, -1.0f);
            return read;
        }
        if (read >= 0) {
            ++this.totalRead;
            this.listener.onProgressChanged(this.totalRead, this.total, (float)this.totalRead * 1.0f / (float)this.total);
        }
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.stream.read(b, off, len);
        if (this.total < 0L) {
            this.listener.onProgressChanged(-1L, -1L, -1.0f);
            return read;
        }
        if (read >= 0) {
            this.totalRead += (long)read;
            this.listener.onProgressChanged(this.totalRead, this.total, (float)this.totalRead * 1.0f / (float)this.total);
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        if (this.stream != null) {
            this.stream.close();
        }
    }
}

