/*
 * Decompiled with CFR 0.152.
 */
package com.fpt.okhttp.progress;

import com.fpt.okhttp.listener.OnProgressListener;
import com.fpt.okhttp.progress.ProgressInputStream;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

public class DownloadResponseBody
extends ResponseBody {
    private ResponseBody responseBody;
    private OnProgressListener progressListener;
    private BufferedSource progressSource;

    public DownloadResponseBody(ResponseBody responseBody, OnProgressListener progressListener) {
        this.responseBody = responseBody;
        this.progressListener = progressListener;
    }

    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    public long contentLength() {
        return this.responseBody.contentLength();
    }

    public BufferedSource source() {
        if (this.progressListener == null) {
            return this.responseBody.source();
        }
        ProgressInputStream progressInputStream = new ProgressInputStream(this.responseBody.source().inputStream(), this.progressListener, this.contentLength());
        this.progressSource = Okio.buffer((Source)Okio.source((InputStream)progressInputStream));
        return this.progressSource;
    }

    public void close() {
        if (this.progressSource != null) {
            try {
                this.progressSource.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

