/*
 * Decompiled with CFR 0.152.
 */
package com.fpt.okhttp.interceptor;

import android.support.annotation.NonNull;
import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Map;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.Buffer;
import okio.BufferedSink;
import okio.BufferedSource;

public abstract class AbsInterceptor
implements Interceptor {
    private final Charset UTF8 = Charset.forName("UTF-8");

    public Response intercept(@NonNull Interceptor.Chain chain) throws IOException {
        Request request = chain.request();
        try {
            Map<String, String> headers = this.addHeaders();
            Request.Builder requestBuilder = request.newBuilder();
            if (headers != null && !headers.isEmpty()) {
                for (String key : headers.keySet()) {
                    requestBuilder.addHeader(key, headers.get(key));
                }
            }
            request = requestBuilder.build();
            String url = request.url().toString();
            String method = request.method();
            long t1 = System.nanoTime();
            RequestBody requestBody = request.body();
            if (requestBody != null) {
                StringBuilder sb = new StringBuilder();
                Buffer buffer = new Buffer();
                requestBody.writeTo((BufferedSink)buffer);
                Charset charset = this.UTF8;
                MediaType contentType = requestBody.contentType();
                if (contentType != null) {
                    charset = contentType.charset(charset);
                }
                if (this.isPlaintext(buffer)) {
                    assert (charset != null);
                    sb.append(buffer.readString(charset));
                    assert (contentType != null);
                    sb.append(" (Content-Type = ").append(contentType.toString()).append(",").append(requestBody.contentLength()).append("-byte body)");
                } else {
                    assert (contentType != null);
                    sb.append(" (Content-Type = ").append(contentType.toString()).append(",binary ").append(requestBody.contentLength()).append("-byte body omitted)");
                }
                this.showRequestMsg(url, method, request.headers(), sb.toString());
            }
            Response response = chain.proceed(request);
            long t2 = System.nanoTime();
            ResponseBody body = response.body();
            assert (body != null);
            BufferedSource source = body.source();
            source.request(Long.MAX_VALUE);
            Buffer buffer = source.buffer();
            Charset charset = Charset.defaultCharset();
            MediaType contentType = body.contentType();
            if (contentType != null) {
                charset = contentType.charset(charset);
            }
            assert (charset != null);
            String bodyString = buffer.clone().readString(charset);
            this.showResponseMsg(response.request().url().toString(), (double)(t2 - t1) / 1000000.0, response.headers(), bodyString);
            return response;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return chain.proceed(request);
        }
    }

    public abstract Map<String, String> addHeaders();

    private boolean isPlaintext(Buffer buffer) {
        try {
            Buffer prefix = new Buffer();
            long byteCount = buffer.size() < 64L ? buffer.size() : 64L;
            buffer.copyTo(prefix, 0L, byteCount);
            for (int i = 0; i < 16 && !prefix.exhausted(); ++i) {
                int codePoint = prefix.readUtf8CodePoint();
                if (!Character.isISOControl(codePoint) || Character.isWhitespace(codePoint)) continue;
                return false;
            }
            return true;
        }
        catch (EOFException e) {
            return false;
        }
    }

    public abstract void showRequestMsg(String var1, String var2, Headers var3, String var4);

    public abstract void showResponseMsg(String var1, double var2, Headers var4, String var5);
}

