/*
 * Decompiled with CFR 0.152.
 */
package com.fpt.okhttp.request;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.fpt.okhttp.listener.OnProgressListener;
import com.fpt.okhttp.progress.UploadRequestBody;
import com.google.gson.Gson;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.Request;
import okhttp3.RequestBody;
import okio.BufferedSink;

public class Request {
    public static okhttp3.Request createPostJsonRequest(String url, @NonNull Map<String, Object> params) {
        RequestBody requestBody = FormBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)new Gson().toJson(params));
        return new Request.Builder().url(url).post(requestBody).build();
    }

    public static okhttp3.Request createPostStringRequest(String url, @NonNull String params) {
        RequestBody requestBody = FormBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)params);
        return new Request.Builder().url(url).post(requestBody).build();
    }

    public static okhttp3.Request createGetRequest(String url) {
        return new Request.Builder().url(url).get().build();
    }

    public static okhttp3.Request createGetRequest(String url, Map<String, String> params) {
        StringBuilder urlBuilder = new StringBuilder(url).append("?");
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                urlBuilder.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
        }
        return new Request.Builder().url(urlBuilder.substring(0, urlBuilder.length() - 1)).get().build();
    }

    public static okhttp3.Request createPostRequest(String url, Map<String, Object> params) {
        FormBody.Builder mFormBodyBuilder = new FormBody.Builder();
        if (params != null) {
            for (Map.Entry<String, Object> entry : params.entrySet()) {
                mFormBodyBuilder.add(entry.getKey(), entry.getValue().toString());
            }
        }
        FormBody mFormBody = mFormBodyBuilder.build();
        return new Request.Builder().url(url).post((RequestBody)mFormBody).build();
    }

    public static okhttp3.Request createPostUploadRequest(String url, File uploadFile, final int offset, OnProgressListener listener) {
        final byte[] content = Request.file2Bytes(uploadFile);
        final MediaType contentType = MediaType.parse((String)"application/octet-stream");
        final int contentLength = content.length;
        final int byteCount = contentLength - offset;
        RequestBody requestBody = new RequestBody(){

            @Nullable
            public MediaType contentType() {
                return contentType;
            }

            public long contentLength() throws IOException {
                return contentLength;
            }

            public void writeTo(BufferedSink sink) throws IOException {
                sink.write(content, offset, byteCount);
            }
        };
        UploadRequestBody uploadBody = new UploadRequestBody(requestBody, listener);
        MultipartBody.Builder body = new MultipartBody.Builder().setType(MultipartBody.FORM);
        body.addFormDataPart("file", uploadFile.getName(), (RequestBody)uploadBody);
        return new Request.Builder().url(url).addHeader("Content-Range", offset + "").post((RequestBody)body.build()).build();
    }

    private static byte[] file2Bytes(File file) {
        byte[] buffer = null;
        try {
            int n;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[4096];
            while ((n = fis.read(b)) != -1) {
                bos.write(b, 0, n);
            }
            fis.close();
            bos.close();
            buffer = bos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer;
    }
}

