/*
 * Decompiled with CFR 0.152.
 */
package com.fpt.okhttp.callback;

import android.os.Handler;
import android.os.Looper;
import com.fpt.okhttp.listener.OnDownloadListener;
import com.fpt.okhttp.listener.OnProgressListener;
import com.fpt.okhttp.progress.DownloadResponseBody;
import java.io.File;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Sink;

public class DownloadCallback
implements Callback {
    private Handler mHandler;
    private OnDownloadListener mListener;
    private String filePath;

    public DownloadCallback(String filePath, OnDownloadListener mListener) {
        this.filePath = filePath;
        this.mListener = mListener;
        this.mHandler = new Handler(Looper.getMainLooper());
    }

    public void onFailure(Call call, final IOException e) {
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                DownloadCallback.this.mListener.onFailure(e);
            }
        });
    }

    public void onResponse(Call call, Response response) throws IOException {
        File outFile = new File(this.filePath);
        if (outFile.exists()) {
            if (outFile.length() == 0L) {
                outFile.delete();
            } else {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        DownloadCallback.this.mListener.onSuccess();
                    }
                });
                return;
            }
        }
        outFile.getParentFile().mkdirs();
        outFile.createNewFile();
        DownloadResponseBody responseBody = new DownloadResponseBody(response.body(), new OnProgressListener(){

            @Override
            public void onProgressChanged(final long numBytes, final long totalBytes, final float percent) {
                DownloadCallback.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        DownloadCallback.this.mListener.onProgressChanged(numBytes, totalBytes, percent);
                    }
                });
            }
        });
        BufferedSource source = responseBody.source();
        BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)outFile));
        source.readAll((Sink)sink);
        sink.flush();
        source.close();
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                DownloadCallback.this.mListener.onSuccess();
            }
        });
    }
}

