package com.foresee.sdk.cxMeasure.tracker.listeners;

import com.foresee.sdk.common.configuration.EligibleMeasureConfigurations;
import com.foresee.sdk.common.configuration.MeasureConfiguration;

/**
 * Created by ardavan.kalhori on 16-04-22.
 */
public interface CustomInSessionInviteListener extends BaseInviteListener
{
    /**
     * Called when invite is ready to be shown
     * @param measures measure configurations related to this invite
     */
    void showInvite(EligibleMeasureConfigurations measures);

    /**
     * Called when the survey is presented
     */
    void onSurveyPresented();

    /**
     * Called when the survey is completed by user
     */
    void onSurveyCompleted();

    /**
     * Called when the survey is cancelled by user
     */
    void onSurveyCancelledByUser();

    /**
     * Called when the survey could not be completed due to a network error
     */
    void onSurveyCancelledWithNetworkError();
}
