package com.foresee.sdk.common.instrumentation;

import java.lang.annotation.*;

/**
 * Ignores unwanted page views
 *
 * Any activity's onResume event will cause an increment of the page view count in the ForeSee SDK.
 * When dealing with full-screen fragments it is often best to use the manual ForeSee.incrementPageViews method on the
 * fragment's onResume method. In those cases this will allow you to suppress the page view increment for the containing
 * activity.
 *
 * Use this if you notice the page view count is larger than expected from your manual page view increments
 */
@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
public @interface IgnorePageViews {
}
