package com.foresee.sdk.cxMeasure.tracker.listeners;

import com.foresee.sdk.common.configuration.EligibleMeasureConfigurations;
import com.foresee.sdk.common.configuration.MeasureConfiguration;

/**
 * Created by ardavan.kalhori on 16-04-22.
 */
public interface DefaultInviteListener extends BaseInviteListener
{
    /**
     * Called when invite presented
     * @param measures measure configurations related to this invite
     */
    void onInvitePresented(EligibleMeasureConfigurations measures);

    /**
     * Called when invite could not be presented due to a network error
     * @param measures measure configurations related to this invite
     */
    void onInviteCancelledWithNetworkError(EligibleMeasureConfigurations measures);

    /**
     * Called when the survey is presented
     * @param measures measure configurations related to this invite
     */
    void onSurveyPresented(EligibleMeasureConfigurations measures);

    /**
     * Called when the survey is completed by user
     * @param measures measure configurations related to this invite
     */
    void onSurveyCompleted(EligibleMeasureConfigurations measures);

    /**
     * Called when the survey is cancelled by user
     * @param measures measure configurations related to this invite
     */
    void onSurveyCancelledByUser(EligibleMeasureConfigurations measures);

    /**
     * Called when the survey could not be completed due to a network error
     * @param measures measure configurations related to this invite
     */
    void onSurveyCancelledWithNetworkError(EligibleMeasureConfigurations measures);
}
