package com.foresee.sdk;

/**
 * Created by alan.wang on 7/23/18.
 */

public interface ForeSeeFeedbackListener {
    /**
     * Called when a feedback is presented
     * @param feedbackName the given feedback name
     */
    void onFeedbackPresented(String feedbackName);

    /**
     * Called when a feedback is not presented due to a network error
     * @param feedbackName the given feedback name
     */
    void onFeedbackNotPresentedWithNetworkError(String feedbackName);

    /**
     * Called when a feedback is not presented due to the feedback is disabled
     * @param feedbackName the given feedback name
     */
    void onFeedbackNotPresentedWithDisabled(String feedbackName);

    /**
     * Called when a feedback is successfully submitted
     * @param feedbackName the given feedback name
     */
    void onFeedbackSubmitted(String feedbackName);

    /**
     * Called when a feedback is presented but has failed to submitted due to user has aborted it
     * @param feedbackName the given feedback name
     */
    void onFeedbackNotSubmittedWithAbort(String feedbackName);

    /**
     * Called when a feedback is presented but has failed to submitted due to a network error
     * @param feedbackName the given feedback name
     */
    void onFeedbackNotSubmittedWithNetworkError(String feedbackName);

    /**
     * Called when a call to the {@link ForeSeeFeedback#checkIfFeedbackEnabledForName(String)}
     * method or to the {@link ForeSeeFeedback#checkIfFeedbackEnabled()} method has retrieved
     * the status of a given feedback.
     *
     * @param feedbackName the name of the given feedback
     * @param enabled true if the given feedback is enabled, otherwise false
     */
    void onFeedbackStatusRetrieved(String feedbackName, boolean enabled);

}
