package com.foresee.sdk.common.configuration;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Class representing eligible measure configurations
 */
public class EligibleMeasureConfigurations implements Serializable {
    // The eligible measure configurations
    private List<MeasureConfiguration> eligibleMeasureConfigurations = new ArrayList<>();
    // The index of measure that is chosen for the single displayed invite
    private Integer chosenMeasureIndex;

    public EligibleMeasureConfigurations(
            List<MeasureConfiguration> eligibleMeasureConfigurations,
            Integer chosenMeasureIndex) {
        this.eligibleMeasureConfigurations = eligibleMeasureConfigurations;
        this.chosenMeasureIndex = chosenMeasureIndex;
    }

    public List<MeasureConfiguration> getEligibleMeasureConfigurations() {
        return eligibleMeasureConfigurations;
    }

    public Integer getChosenMeasureIndex() {
        return chosenMeasureIndex;
    }

    public MeasureConfiguration getChosenEligibleMeasureConfiguration() {
        MeasureConfiguration result = null;

        if (chosenMeasureIndex != null
                && eligibleMeasureConfigurations.size() > chosenMeasureIndex) {
            result = eligibleMeasureConfigurations.get(chosenMeasureIndex);
        }

        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        EligibleMeasureConfigurations that = (EligibleMeasureConfigurations) o;

        if (eligibleMeasureConfigurations != null ? !eligibleMeasureConfigurations.equals(that.eligibleMeasureConfigurations) : that.eligibleMeasureConfigurations != null)
            return false;
        return chosenMeasureIndex != null ? chosenMeasureIndex.equals(that.chosenMeasureIndex) : that.chosenMeasureIndex == null;
    }

    @Override
    public int hashCode() {
        int result = eligibleMeasureConfigurations != null ? eligibleMeasureConfigurations.hashCode() : 0;
        result = 31 * result + (chosenMeasureIndex != null ? chosenMeasureIndex.hashCode() : 0);
        return result;
    }

    @Override
    public String toString() {
        return "EligibleMeasureConfigurations{" +
                "eligibleMeasureConfigurations=" + eligibleMeasureConfigurations +
                ", chosenMeasureIndex=" + chosenMeasureIndex +
                '}';
    }
}
