/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.bind;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

public class ArrayCodec {
    private static final String UTF8 = "UTF-8";

    public <T> String getValueAsString(Class<T> componentType, Object value) {
        this.validateComponentType(componentType);
        try {
            Object[] array = (Object[])value;
            ArrayList<String> encoded = new ArrayList<String>(array.length);
            for (Object obj : array) {
                if (obj == null) {
                    encoded.add(null);
                    continue;
                }
                encoded.add('\"' + URLEncoder.encode(obj.toString(), UTF8) + '\"');
            }
            return "[" + Joiner.on((String)",").useForNull("null").join(encoded) + "]";
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Cannot encode array", e);
        }
    }

    public <T> T[] deserialize(Class<T> componentType, String source) {
        if (source == null) {
            throw new ArrayCodecException("Unable to parse null array.");
        }
        ArrayList<T> result = new ArrayList<T>();
        if ((source = this.trimEnclosing(source, '[', ']').trim()).length() > 0) {
            List encoded = Splitter.on((String)",").splitToList((CharSequence)source);
            for (String s : encoded) {
                if ("null".equals(s)) {
                    result.add(null);
                    continue;
                }
                try {
                    s = this.trimEnclosing(s, '\"', '\"');
                    s = URLDecoder.decode(s, UTF8);
                    T t = componentType.getConstructor(String.class).newInstance(s);
                    result.add(t);
                }
                catch (Exception e) {
                    throw new ArrayCodecException("Cannot parse array", e);
                }
            }
        }
        Object[] t = result.toArray();
        return t;
    }

    private String trimEnclosing(String source, char open, char close) {
        if (source.charAt(0) != open || source.charAt(source.length() - 1) != close) {
            throw new ArrayCodecException("Cannot trim enclosing characters.");
        }
        return source.substring(1, source.length() - 1);
    }

    private <T> void validateComponentType(Class<T> type) {
        if (type.isArray()) {
            throw new ArrayCodecException("Multi-dimensional arrays not supported.");
        }
        try {
            type.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            throw new ArrayCodecException("Cannot find suitable constructor");
        }
    }

    public static class ArrayCodecException
    extends RuntimeException {
        public ArrayCodecException(String message) {
            super(message);
        }

        public ArrayCodecException(String message, Throwable th) {
            super(message, th);
        }
    }
}

