/*
 * Decompiled with CFR 0.152.
 */
package com.fooock.lib.phone.tracker;

import android.support.annotation.NonNull;

public class Configuration {
    private final Builder builder;

    private Configuration(Builder builder) {
        this.builder = builder;
    }

    public boolean usingWifi() {
        return this.builder.useWifi;
    }

    public boolean usingGps() {
        return this.builder.useGps;
    }

    public boolean usingCell() {
        return this.builder.useCell;
    }

    public Wifi wifiConfiguration() {
        return this.builder.wifiConfiguration;
    }

    public Cell cellConfiguration() {
        return this.builder.cellConfiguration;
    }

    public Gps gpsConfiguration() {
        return this.builder.gpsConfiguration;
    }

    public static class Gps {
        private static final long MIN_TIME_UPDATES = 5000L;
        private static final float MIN_DISTANCE_UPDATES = 5.0f;
        private long minTimeUpdate = 5000L;
        private float minDistanceUpdate = 5.0f;

        public long getMinTimeUpdate() {
            return this.minTimeUpdate;
        }

        public void setMinTimeUpdate(long minTimeUpdate) {
            this.minTimeUpdate = minTimeUpdate;
        }

        public float getMinDistanceUpdate() {
            return this.minDistanceUpdate;
        }

        public void setMinDistanceUpdate(float minDistanceUpdate) {
            this.minDistanceUpdate = minDistanceUpdate;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Gps gps = (Gps)o;
            if (this.minTimeUpdate != gps.minTimeUpdate) {
                return false;
            }
            return this.minDistanceUpdate == gps.minDistanceUpdate;
        }

        public int hashCode() {
            int result = (int)(this.minTimeUpdate ^ this.minTimeUpdate >>> 32);
            result = 31 * result + (this.minDistanceUpdate != 0.0f ? Float.floatToIntBits(this.minDistanceUpdate) : 0);
            return result;
        }
    }

    public static class Cell {
        private static final int SCAN_DEFAULT_DELAY = 7000;
        private int scanDelay = 7000;

        public int getScanDelay() {
            return this.scanDelay;
        }

        public void setScanDelay(int scanDelay) {
            this.scanDelay = scanDelay;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cell cell = (Cell)o;
            return this.scanDelay == cell.scanDelay;
        }

        public int hashCode() {
            return this.scanDelay;
        }
    }

    public static class Wifi {
        private static final int SCAN_DEFAULT_DELAY = 4000;
        private int scanDelay = 4000;

        public int getScanDelay() {
            return this.scanDelay;
        }

        public void setScanDelay(int scanDelay) {
            this.scanDelay = scanDelay;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Wifi wifi = (Wifi)o;
            return this.scanDelay == wifi.scanDelay;
        }

        public int hashCode() {
            return this.scanDelay;
        }
    }

    public static class Builder {
        private boolean useGps = true;
        private boolean useWifi = true;
        private boolean useCell = true;
        private Wifi wifiConfiguration = new Wifi();
        private Cell cellConfiguration = new Cell();
        private Gps gpsConfiguration = new Gps();

        public Builder useGps(boolean useGps) {
            this.useGps = useGps;
            return this;
        }

        public Builder useWifi(boolean useWifi) {
            this.useWifi = useWifi;
            return this;
        }

        public Builder useCell(boolean useCell) {
            this.useCell = useCell;
            return this;
        }

        public Builder wifi(@NonNull Wifi wifiConf) {
            this.wifiConfiguration = wifiConf;
            return this;
        }

        public Builder cell(@NonNull Cell cellConf) {
            this.cellConfiguration = cellConf;
            return this;
        }

        public Builder gps(@NonNull Gps gpsConf) {
            this.gpsConfiguration = gpsConf;
            return this;
        }

        @NonNull
        public Configuration create() {
            return new Configuration(this);
        }
    }
}

