/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.spring.messagesource;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.FileTools;
import com.foilen.smalltools.trigger.SmoothTrigger;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.context.NoSuchMessageException;

public class UsageMonitoringMessageSource
implements MessageSource {
    private static final Logger logger = LoggerFactory.getLogger(UsageMonitoringMessageSource.class);
    private String basename;
    private File tmpUsed;
    private SmoothTrigger smoothTrigger;
    private Object lock = new Object();
    private Map<Locale, File> filePerLocale = new HashMap<Locale, File>();
    private Map<Locale, Map<String, String>> messagesPerLocale = new HashMap<Locale, Map<String, String>>();
    private Set<String> allCodesInFiles = new HashSet<String>();
    private Set<String> knownUsedCodes = new HashSet<String>();

    protected static String format(String value, Object[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                String text = "null";
                if (arg != null) {
                    text = arg.toString();
                }
                value = value.replaceAll("\\{" + i + "\\}", text);
            }
        }
        return value;
    }

    public UsageMonitoringMessageSource(String basename) {
        this.basename = basename;
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKnownUsedCode(String code) {
        Object object = this.lock;
        synchronized (object) {
            if (this.knownUsedCodes.add(code)) {
                Object anyValue = this.findAnyValue(code);
                if (anyValue == null) {
                    anyValue = "!" + code + "!";
                }
                for (Map<String, String> messages : this.messagesPerLocale.values()) {
                    if (messages.containsKey(code)) continue;
                    messages.put(code, (String)anyValue);
                }
                this.smoothTrigger.request();
            }
        }
    }

    private String findAnyValue(String missingCode) {
        for (Map<String, String> messages : this.messagesPerLocale.values()) {
            String codeValue = messages.get(missingCode);
            if (codeValue == null) continue;
            return codeValue;
        }
        return null;
    }

    public String getMessage(MessageSourceResolvable resolvable, Locale locale) throws NoSuchMessageException {
        throw new SmallToolsException("Not implemented yet");
    }

    public String getMessage(String code, Object[] args, Locale locale) throws NoSuchMessageException {
        this.addKnownUsedCode(code);
        String value = this.messagesPerLocale.get(locale).get(code);
        return UsageMonitoringMessageSource.format(value, args);
    }

    public String getMessage(String code, Object[] args, String defaultMessage, Locale locale) {
        this.addKnownUsedCode(code);
        String value = this.messagesPerLocale.get(locale).get(code);
        return UsageMonitoringMessageSource.format(value, args);
    }

    private void init() {
        File basenameFile = new File(this.basename);
        logger.info("Base name is {}", (Object)this.basename);
        File directory = basenameFile.getParentFile();
        logger.info("Base directory is {}", (Object)directory.getAbsoluteFile());
        if (!directory.exists()) {
            throw new SmallToolsException("Directory: " + directory.getAbsolutePath() + " does not exists");
        }
        this.tmpUsed = new File(directory.getAbsolutePath() + File.separatorChar + "_messages_usage.txt");
        String startswith = basenameFile.getName() + "_";
        String endswith = ".properties";
        for (File file : directory.listFiles((dir, name) -> name.startsWith(startswith) && name.endsWith(endswith))) {
            logger.info("Found messages file {}", (Object)directory.getAbsoluteFile());
            String filename = file.getName();
            String localePart = filename.substring(startswith.length(), filename.length() - endswith.length());
            Locale locale = Locale.of(localePart);
            logger.info("Locale is {} -> {}", (Object)localePart, (Object)locale);
            this.filePerLocale.put(locale, file);
            Properties properties = new Properties();
            try (FileInputStream inputStream = new FileInputStream(file);){
                properties.load(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                logger.error("Problem reading the property file {}", (Object)file.getAbsoluteFile(), (Object)e);
                throw new SmallToolsException("Problem reading the file", (Throwable)e);
            }
            HashMap<String, String> messages = new HashMap<String, String>();
            this.messagesPerLocale.put(locale, messages);
            for (Object key : properties.keySet()) {
                String name2 = (String)key;
                String value = properties.getProperty(name2);
                this.allCodesInFiles.add(name2);
                messages.put(name2, value);
            }
        }
        for (Locale locale : this.filePerLocale.keySet()) {
            HashSet<String> missingCodes = new HashSet<String>();
            Map<String, String> messagesForCurrentLocale = this.messagesPerLocale.get(locale);
            missingCodes.addAll(this.allCodesInFiles);
            missingCodes.removeAll(messagesForCurrentLocale.keySet());
            for (String missingCode : missingCodes) {
                logger.info("Locale {} was missing code {}", (Object)locale, (Object)missingCode);
                String codeValue = this.findAnyValue(missingCode);
                messagesForCurrentLocale.put(missingCode, codeValue);
            }
        }
        if (this.tmpUsed.exists()) {
            for (String line : FileTools.readFileLinesIteration((String)this.tmpUsed.getAbsolutePath())) {
                this.knownUsedCodes.add(line);
            }
        }
        this.smoothTrigger = new SmoothTrigger(() -> {
            Object object = this.lock;
            synchronized (object) {
                logger.info("Begin saving locale files");
                for (Map.Entry<Locale, File> entry : this.filePerLocale.entrySet()) {
                    Map<String, String> messages = this.messagesPerLocale.get(entry.getKey());
                    try (PrintWriter printWriter = new PrintWriter(entry.getValue(), StandardCharsets.UTF_8.toString());){
                        for (String code : this.knownUsedCodes.stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList())) {
                            printWriter.println(code + "=" + messages.get(code));
                        }
                        printWriter.println();
                        HashSet<String> unknownCodes = new HashSet<String>();
                        unknownCodes.addAll(messages.keySet());
                        unknownCodes.removeAll(this.knownUsedCodes);
                        if (unknownCodes.isEmpty()) continue;
                        printWriter.println("# Unknown");
                        printWriter.println();
                        for (String code : unknownCodes.stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList())) {
                            printWriter.println(code + "=" + messages.get(code));
                        }
                        printWriter.println();
                    }
                    catch (Exception e) {
                        logger.error("Could not write the file", (Throwable)e);
                    }
                }
                FileTools.writeFile((String)Joiner.on((char)'\n').join((Iterable)this.knownUsedCodes.stream().sorted(String.CASE_INSENSITIVE_ORDER).collect(Collectors.toList())), (File)this.tmpUsed);
                logger.info("Done saving locale files");
            }
        }).setDelayAfterLastTriggerMs(5000L).setMaxDelayAfterFirstRequestMs(10000L).setFirstPassThrough(true).start();
        this.smoothTrigger.request();
    }
}

