/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.reflection;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.reflection.ReflectionTools;
import com.foilen.smalltools.tools.AssertTools;
import java.beans.PropertyDescriptor;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.TypeMismatchException;

public class BeanPropertiesCopierTools {
    private BeanWrapper sourceWrapper;
    private BeanWrapper destinationWrapper;

    public BeanPropertiesCopierTools(BeanWrapper sourceWrapper, BeanWrapper destinationWrapper) {
        AssertTools.assertNotNull((Object)sourceWrapper, (String)"The sourceWrapper cannot be null");
        AssertTools.assertNotNull((Object)sourceWrapper.getWrappedInstance(), (String)"The source cannot be null");
        AssertTools.assertNotNull((Object)destinationWrapper, (String)"The destinationWrapper cannot be null");
        AssertTools.assertNotNull((Object)destinationWrapper.getWrappedInstance(), (String)"The destination cannot be null");
        this.sourceWrapper = sourceWrapper;
        this.destinationWrapper = destinationWrapper;
    }

    public BeanPropertiesCopierTools(Object source, Class<?> destinationClass) {
        AssertTools.assertNotNull(destinationClass, (String)"The destinationClass cannot be null");
        Object destination = ReflectionTools.instantiate(destinationClass, (Object[])new Object[0]);
        this.init(source, destination);
    }

    public BeanPropertiesCopierTools(Object source, Object destination) {
        this.init(source, destination);
    }

    public BeanPropertiesCopierTools copyAllSameProperties() {
        for (PropertyDescriptor propertyDescriptor : this.sourceWrapper.getPropertyDescriptors()) {
            String propertyName = propertyDescriptor.getName();
            try {
                this.destinationWrapper.setPropertyValue(propertyName, this.sourceWrapper.getPropertyValue(propertyName));
            }
            catch (InvalidPropertyException | TypeMismatchException throwable) {
                // empty catch block
            }
        }
        return this;
    }

    public BeanPropertiesCopierTools copyProperty(String propertyName) {
        return this.copyProperty(propertyName, propertyName);
    }

    public BeanPropertiesCopierTools copyProperty(String sourcePropertyName, String destinationPropertyName) {
        Object value = this.sourceWrapper.getPropertyValue(sourcePropertyName);
        this.destinationWrapper.setPropertyValue(destinationPropertyName, value);
        return this;
    }

    public Object getDestination() {
        return this.destinationWrapper.getWrappedInstance();
    }

    public Object getSource() {
        return this.sourceWrapper.getWrappedInstance();
    }

    public <T> T getSourceProperty(String propertyName, Class<T> type) {
        Object value = this.sourceWrapper.getPropertyValue(propertyName);
        if (value == null) {
            return null;
        }
        return (T)value;
    }

    private void init(Object source, Object destination) {
        AssertTools.assertNotNull((Object)source, (String)"The source cannot be null");
        AssertTools.assertNotNull((Object)destination, (String)"The destination cannot be null");
        this.sourceWrapper = new BeanWrapperImpl(source);
        this.destinationWrapper = new BeanWrapperImpl(destination);
    }

    public void setDestinationProperty(String propertyName, Object value) {
        this.destinationWrapper.setPropertyValue(propertyName, value);
    }

    public BeanPropertiesCopierTools updateCollection(Collection<?> sourceCollection, String destinationPropertyName) {
        Class destinationPropertyType;
        AbstractCollection destinationObject = this.destinationWrapper.getPropertyValue(destinationPropertyName);
        boolean setDestination = destinationObject == null;
        HashSet destinationSet = null;
        ArrayList destinationList = null;
        if (setDestination) {
            destinationPropertyType = this.destinationWrapper.getPropertyType(destinationPropertyName);
            if (destinationPropertyType == List.class) {
                destinationObject = destinationList = new ArrayList();
            }
            if (destinationPropertyType == Set.class) {
                destinationSet = new HashSet();
                destinationObject = destinationSet;
            }
        } else {
            destinationPropertyType = destinationObject.getClass();
            if (destinationObject instanceof List) {
                destinationList = destinationObject;
            }
            if (destinationObject instanceof Set) {
                destinationSet = (HashSet)destinationObject;
            }
        }
        if (destinationList == null && destinationSet == null) {
            throw new SmallToolsException("The destination must be a List or a Set. Is a " + destinationPropertyType.getName());
        }
        if (sourceCollection == null) {
            sourceCollection = Collections.emptyList();
        }
        if (destinationList != null) {
            int destPos = 0;
            for (Object next : sourceCollection) {
                if (destPos >= destinationList.size() || !destinationList.get(destPos).equals(next)) {
                    destinationList.add(destPos, next);
                }
                ++destPos;
            }
            while (destPos < destinationList.size()) {
                destinationList.remove(destPos);
            }
        }
        if (destinationSet != null) {
            Iterator destinationIt = destinationSet.iterator();
            while (destinationIt.hasNext()) {
                Object next = destinationIt.next();
                if (sourceCollection.contains(next)) continue;
                destinationIt.remove();
            }
            for (Object next : sourceCollection) {
                if (destinationSet.contains(next)) continue;
                destinationSet.add(next);
            }
        }
        if (setDestination) {
            this.destinationWrapper.setPropertyValue(destinationPropertyName, destinationObject);
        }
        return this;
    }

    public BeanPropertiesCopierTools updateCollection(String propertyName) {
        return this.updateCollection(propertyName, propertyName);
    }

    public BeanPropertiesCopierTools updateCollection(String sourcePropertyName, String destinationPropertyName) {
        Collection sourceCollection = (Collection)this.sourceWrapper.getPropertyValue(sourcePropertyName);
        return this.updateCollection(sourceCollection, destinationPropertyName);
    }
}

