/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.email;

import com.foilen.smalltools.email.EmailAttachment;
import com.foilen.smalltools.email.EmailBuilder;
import com.foilen.smalltools.email.EmailService;
import com.foilen.smalltools.exception.SmallToolsException;
import jakarta.mail.internet.MimeMessage;
import java.nio.charset.StandardCharsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.InputStreamSource;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;

public class EmailServiceSpring
implements EmailService {
    @Autowired
    private JavaMailSender mailSender;

    @Override
    public void sendEmail(EmailBuilder emailBuilder) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, StandardCharsets.UTF_8.name());
            helper.setFrom(emailBuilder.getFrom());
            if (emailBuilder.getReplyTo() != null) {
                helper.setReplyTo(emailBuilder.getReplyTo());
            }
            for (String to : emailBuilder.getTos()) {
                helper.addTo(to);
            }
            for (String cc : emailBuilder.getCcs()) {
                helper.addCc(cc);
            }
            for (String bcc : emailBuilder.getBccs()) {
                helper.addBcc(bcc);
            }
            helper.setSubject(emailBuilder.getSubject());
            helper.setText(emailBuilder.getBody(), emailBuilder.isHtml());
            for (EmailAttachment emailAttachment : emailBuilder.getInlineAttachments()) {
                helper.addInline(emailAttachment.getId(), emailAttachment.getResource());
            }
            for (EmailAttachment emailAttachment : emailBuilder.getAttachments()) {
                helper.addAttachment(emailAttachment.getId(), (InputStreamSource)emailAttachment.getResource());
            }
            this.mailSender.send(message);
        }
        catch (Exception e) {
            throw new SmallToolsException("Could not send email", (Throwable)e);
        }
    }

    @Override
    public void sendHtmlEmail(String from, String to, String subject, String html) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(from);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(html, true);
            this.mailSender.send(message);
        }
        catch (Exception e) {
            throw new SmallToolsException("Could not send email", (Throwable)e);
        }
    }

    @Override
    public void sendTextEmail(String from, String to, String subject, String text) {
        try {
            MimeMessage message = this.mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true);
            helper.setFrom(from);
            helper.setTo(to);
            helper.setSubject(subject);
            helper.setText(text, false);
            this.mailSender.send(message);
        }
        catch (Exception e) {
            throw new SmallToolsException("Could not send email", (Throwable)e);
        }
    }

    public void setMailSender(JavaMailSender mailSender) {
        this.mailSender = mailSender;
    }
}

