/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.mongodb.spring.cache;

import com.foilen.smalltools.mongodb.distributed.MongoDbReentrantLock;
import com.foilen.smalltools.mongodb.spring.cache.MongoDbCache;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import org.bson.Document;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class MongoDbCacheManager
implements CacheManager {
    private final MongoClient mongoClient;
    private final String databaseName;
    private final String collectionNamePrefix;
    private final MongoDbReentrantLock lock;
    private final long defaultMaxDurationInSec;
    private final Map<String, Long> maxDurationInSecByCacheName = new HashMap<String, Long>();

    public MongoDbCacheManager(MongoClient mongoClient, String databaseName, String collectionNamePrefix, MongoDbReentrantLock lock, long defaultMaxDurationInSec) {
        this(mongoClient, databaseName, collectionNamePrefix, lock, defaultMaxDurationInSec, Map.of());
    }

    public MongoDbCacheManager(MongoClient mongoClient, String databaseName, String collectionNamePrefix, MongoDbReentrantLock lock, long defaultMaxDurationInSec, Map<String, Long> maxDurationInSecByCacheName) {
        this.mongoClient = mongoClient;
        this.databaseName = databaseName;
        this.collectionNamePrefix = collectionNamePrefix;
        this.lock = lock;
        this.defaultMaxDurationInSec = defaultMaxDurationInSec;
        this.maxDurationInSecByCacheName.putAll(maxDurationInSecByCacheName);
    }

    public Cache getCache(String cacheName) {
        Long durationInSec = this.maxDurationInSecByCacheName.getOrDefault(cacheName, this.defaultMaxDurationInSec);
        MongoCollection mongoCollection = this.mongoClient.getDatabase(this.databaseName).getCollection(this.collectionNamePrefix + cacheName);
        return new MongoDbCache(cacheName, this.mongoClient, (MongoCollection<Document>)mongoCollection, this.lock, durationInSec);
    }

    public Collection<String> getCacheNames() {
        TreeSet<String> cacheNames = new TreeSet<String>();
        this.mongoClient.getDatabase(this.databaseName).listCollectionNames().forEach(collectionName -> {
            if (collectionName.startsWith(this.collectionNamePrefix)) {
                cacheNames.add(collectionName.substring(this.collectionNamePrefix.length()));
            }
        });
        return cacheNames;
    }
}

