/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.trigger;

import com.foilen.smalltools.tools.ExecutorsTools;
import com.foilen.smalltools.trigger.SmoothTrigger;
import com.foilen.smalltools.trigger.SmoothTriggerState;
import java.util.Iterator;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SmoothTriggerRunnable
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(SmoothTriggerRunnable.class);
    private SmoothTrigger smoothTrigger;
    private SmoothTriggerState state = SmoothTriggerState.IDLE;
    private volatile long requestMade = -1L;
    private Queue<Future<?>> futures = new ConcurrentLinkedQueue();
    private volatile boolean requestStop = false;

    public SmoothTriggerRunnable(SmoothTrigger smoothTrigger) {
        this.smoothTrigger = smoothTrigger;
    }

    public void cancelPending() {
        logger.debug("Cancelling pending. Current state [{}]", (Object)this.state);
        switch (this.state) {
            case COOLDOWN: {
                break;
            }
            case IDLE: {
                break;
            }
            case WARMUP: {
                this.requestMade = 0L;
                this.state = SmoothTriggerState.COOLDOWN;
            }
        }
        logger.debug("Ending state [{}]", (Object)this.state);
    }

    public void executeActionIfPending(boolean wait) {
        logger.debug("executeActionIfPending. Current state [{}]", (Object)this.state);
        if (this.state == SmoothTriggerState.WARMUP) {
            this.state = SmoothTriggerState.COOLDOWN;
            logger.debug("Executing action");
            Future<?> future = ExecutorsTools.getCachedThreadPool().submit(this.smoothTrigger.getAction());
            this.futures.add(future);
        }
        logger.debug("executeActionIfPending. Ending state [{}]", (Object)this.state);
        if (wait) {
            logger.debug("Waiting for all the actions to finish executing");
            Iterator it = this.futures.iterator();
            while (it.hasNext()) {
                Future future = (Future)it.next();
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    continue;
                }
                it.remove();
            }
            logger.debug("All the actions are finished to execute");
        }
    }

    public void request() {
        this.requestMade = System.currentTimeMillis();
    }

    public void requestStop() {
        logger.debug("Requesting stop");
        this.requestStop = true;
    }

    @Override
    public void run() {
        logger.info("Starting");
        long nextWarmupFinished = -1L;
        long nextMaxFinished = -1L;
        while (!this.requestStop) {
            Future<?> future;
            long now = System.currentTimeMillis();
            logger.debug("Current state [{}] ; now [{}]", (Object)this.state, (Object)now);
            if (this.state == SmoothTriggerState.COOLDOWN && nextWarmupFinished <= now) {
                this.state = SmoothTriggerState.IDLE;
                logger.debug("Change state [{}]", (Object)this.state, (Object)now);
            }
            if (this.requestMade >= 0L) {
                logger.debug("A request was made at [{}]", (Object)this.requestMade);
                SmoothTriggerState previousState = this.state;
                this.state = SmoothTriggerState.WARMUP;
                nextWarmupFinished = this.requestMade + this.smoothTrigger.getDelayAfterLastTriggerMs();
                if (nextWarmupFinished < 0L) {
                    nextWarmupFinished = Long.MAX_VALUE;
                }
                if (nextMaxFinished == -1L && (nextMaxFinished = this.requestMade + this.smoothTrigger.getMaxDelayAfterFirstRequestMs()) < 0L) {
                    nextMaxFinished = Long.MAX_VALUE;
                }
                this.requestMade = -1L;
                if (this.smoothTrigger.isFirstPassThrough() && previousState == SmoothTriggerState.IDLE) {
                    logger.debug("Execute since pass through and was idling");
                    this.executeActionIfPending(false);
                    nextWarmupFinished += this.smoothTrigger.getDelayAfterLastTriggerMs();
                }
            }
            logger.debug("State [{}] ; now [{}] ; nextWarmupFinished [{}] ; nextMaxFinished [{}]", new Object[]{this.state, now, nextWarmupFinished, nextMaxFinished});
            switch (this.state) {
                case COOLDOWN: {
                    break;
                }
                case IDLE: {
                    break;
                }
                case WARMUP: {
                    if (nextWarmupFinished > now && nextMaxFinished > now) break;
                    this.executeActionIfPending(false);
                    nextWarmupFinished += this.smoothTrigger.getDelayAfterLastTriggerMs();
                    nextMaxFinished = -1L;
                }
            }
            while ((future = this.futures.peek()) != null && future.isDone()) {
                this.futures.poll();
            }
            switch (this.state) {
                case COOLDOWN: 
                case IDLE: {
                    try {
                        Thread.sleep(120000L);
                    }
                    catch (InterruptedException interruptedException) {}
                    break;
                }
                case WARMUP: {
                    long sooner = Math.min(nextMaxFinished, nextWarmupFinished);
                    long delta = sooner - now;
                    if (delta <= 0L) break;
                    try {
                        Thread.sleep(delta);
                        break;
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        logger.info("Ended");
    }
}

