/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.FileTools;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public final class UrlTools {
    public static void saveToFile(String url, File outFile) {
        try {
            UrlTools.saveToFile(new URL(url), outFile);
        }
        catch (MalformedURLException e) {
            throw new SmallToolsException("Invalid URL", e);
        }
    }

    public static void saveToFile(URL url, File outFile) {
        try {
            URLConnection connection = url.openConnection();
            if (!outFile.exists() || outFile.length() != connection.getContentLengthLong()) {
                FileTools.writeFile(connection.getInputStream(), outFile);
            }
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem downloading the file", e);
        }
    }

    private UrlTools() {
    }
}

