/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class MultiDependenciesResolverTools {
    private Map<String, Set<String>> dependsOnByItem = new HashMap<String, Set<String>>();

    public MultiDependenciesResolverTools addDependency(String item, String dependsOnItem) {
        if (Strings.isNullOrEmpty((String)dependsOnItem)) {
            this.addItems(item);
            return this;
        }
        this.addItems(item, dependsOnItem);
        this.dependsOnByItem.get(item).add(dependsOnItem);
        return this;
    }

    public void addItems(String ... items) {
        for (String item : items) {
            if (Strings.isNullOrEmpty((String)item) || this.dependsOnByItem.containsKey(item)) continue;
            this.dependsOnByItem.put(item, new HashSet());
        }
    }

    public List<String> getExecution() {
        HashMap dependsOnByItemCopy = new HashMap();
        for (Map.Entry<String, Set<String>> entry : this.dependsOnByItem.entrySet()) {
            dependsOnByItemCopy.put(entry.getKey(), new HashSet(entry.getValue()));
        }
        ArrayList<String> plan = new ArrayList<String>();
        while (!dependsOnByItemCopy.isEmpty()) {
            ArrayList<String> nextStage = new ArrayList<String>();
            Iterator it = dependsOnByItemCopy.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry next = it.next();
                if (!((Set)next.getValue()).isEmpty()) continue;
                nextStage.add((String)next.getKey());
                it.remove();
            }
            if (nextStage.isEmpty()) {
                throw new SmallToolsException("Has a circular dependency");
            }
            Collections.sort(nextStage);
            plan.addAll(nextStage);
            dependsOnByItemCopy.values().forEach(dependensOn -> dependensOn.removeAll(nextStage));
        }
        return plan;
    }
}

