/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.tools.StreamsTools;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternetTools {
    private static final Logger logger = LoggerFactory.getLogger(InternetTools.class);
    private static final String LOOPBACK_START_IP_V4 = "127.";
    private static final String LOOPBACK_START_IP_V6_1 = "fe80:";
    private static final String LOOPBACK_START_IP_V6_2 = "0:0:0:0:0:0:0:1";

    public static Set<String> getAllInterfacesIps() {
        HashSet<String> ips = new HashSet<String>();
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfaces.nextElement();
                Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                while (inetAddresses.hasMoreElements()) {
                    int percentPos;
                    InetAddress inetAddress = inetAddresses.nextElement();
                    String address = inetAddress.getHostAddress();
                    if (InternetTools.isIpLocalLoop(address)) continue;
                    if (address.contains(":") && (percentPos = address.lastIndexOf("%")) != -1) {
                        address = address.substring(0, percentPos);
                    }
                    ips.add(address);
                }
            }
        }
        catch (SocketException e) {
            logger.error("Could not get the network interfaces", (Throwable)e);
        }
        return ips;
    }

    public static String getPublicIp() {
        try {
            return StreamsTools.consumeAsString(new URL("https://checkip.foilen.com/").openStream());
        }
        catch (Exception e) {
            logger.error("Could not retrieve the public ip", (Throwable)e);
            return null;
        }
    }

    public static boolean isIpLocalLoop(String ip) {
        return ip.startsWith(LOOPBACK_START_IP_V4) || ip.toLowerCase().startsWith(LOOPBACK_START_IP_V6_1) || ip.equals(LOOPBACK_START_IP_V6_2);
    }

    public static void main(String[] args) {
        System.out.println("Public Internet IP");
        System.out.println("\t[" + InternetTools.getPublicIp() + "]");
        System.out.println();
        System.out.println("All IPS");
        for (String ip : InternetTools.getAllInterfacesIps()) {
            System.out.println("\t[" + ip + "]");
        }
    }
}

