/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public final class FreemarkerTools {
    private static final Configuration freemarkerConfiguration = new Configuration(Configuration.VERSION_2_3_22);

    public static String processTemplate(String resource, Map<String, ?> model) {
        try {
            Template template = freemarkerConfiguration.getTemplate(resource);
            StringWriter stringWriter = new StringWriter();
            template.process(model, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem generating the file", e);
        }
    }

    private FreemarkerTools() {
    }

    static {
        freemarkerConfiguration.setClassForTemplateLoading(FreemarkerTools.class, "/");
        freemarkerConfiguration.setDefaultEncoding(StandardCharsets.UTF_8.name());
        freemarkerConfiguration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
    }
}

