/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.hash.HashMd5sum;
import com.foilen.smalltools.iterable.FileLinesIterable;
import com.foilen.smalltools.streamwrapper.RenamingOnCloseOutputStreamWrapper;
import com.foilen.smalltools.tools.CloseableTools;
import com.foilen.smalltools.tools.DirectoryTools;
import com.foilen.smalltools.tools.StreamsTools;
import com.google.common.base.Joiner;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FileTools {
    private static final Logger log = LoggerFactory.getLogger(FileTools.class);
    private static final Joiner LINES_JOINER = Joiner.on((char)'\n');
    private static final UserPrincipalLookupService USER_PRINCIPAL_LOOKUP_SERVICE = FileSystems.getDefault().getUserPrincipalLookupService();

    public static void appendLine(File file, String line) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file, true);
            out.write((line + "\n").getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            try {
                throw new SmallToolsException("Problem writing to file", e);
            }
            catch (Throwable throwable) {
                CloseableTools.close(out);
                throw throwable;
            }
        }
        CloseableTools.close(out);
    }

    public static void appendLine(String path, String line) {
        FileTools.appendLine(new File(path), line);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void appendLineIfMissing(String path, String line) {
        boolean endsWithEmptyLine = false;
        FileOutputStream out = null;
        File file = new File(path);
        try {
            for (String currLine : FileTools.readFileLinesIteration(file)) {
                if (!currLine.equals(line)) continue;
                return;
            }
            FileInputStream fin = null;
            try {
                fin = new FileInputStream(file);
                fin.skip(file.length() - 1L);
                char c = (char)fin.read();
                endsWithEmptyLine = c == '\n' || c == '\r';
            }
            catch (Exception exception) {
                CloseableTools.close(fin);
                catch (Throwable throwable) {
                    CloseableTools.close(fin);
                    throw throwable;
                }
            }
            CloseableTools.close(fin);
            out = new FileOutputStream(file, true);
        }
        catch (FileNotFoundException e) {
            endsWithEmptyLine = true;
            try {
                out = new FileOutputStream(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        try {
            if (endsWithEmptyLine) {
                ((OutputStream)out).write((line + "\n").getBytes(StandardCharsets.UTF_8));
            } else {
                ((OutputStream)out).write(("\n" + line + "\n").getBytes(StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem writing to file", e);
        }
        finally {
            CloseableTools.close(out);
        }
    }

    public static void changeOwnerAndGroup(File fileOrDirectory, boolean recursive, UserPrincipal owner, GroupPrincipal group) {
        if (!fileOrDirectory.exists()) {
            throw new SmallToolsException("The file or directory " + fileOrDirectory.getAbsolutePath() + " does not exists");
        }
        try {
            Path fileOrDirectoryPath = fileOrDirectory.toPath();
            PosixFileAttributeView view = Files.getFileAttributeView(fileOrDirectoryPath, PosixFileAttributeView.class, new LinkOption[0]);
            view.setOwner(owner);
            view.setGroup(group);
            if (recursive && fileOrDirectory.isDirectory()) {
                for (File child : fileOrDirectory.listFiles()) {
                    FileTools.changeOwnerAndGroup(child, recursive, owner, group);
                }
            }
        }
        catch (IOException e) {
            throw new SmallToolsException("Problem setting owner or group", e);
        }
    }

    public static void changeOwnerAndGroup(String fileOrDirectory, boolean recursive, String owner, String group) {
        try {
            File file = new File(fileOrDirectory);
            UserPrincipal userPrincipal = USER_PRINCIPAL_LOOKUP_SERVICE.lookupPrincipalByName(owner);
            GroupPrincipal groupPrincipal = USER_PRINCIPAL_LOOKUP_SERVICE.lookupPrincipalByGroupName(group);
            FileTools.changeOwnerAndGroup(file, recursive, userPrincipal, groupPrincipal);
        }
        catch (SmallToolsException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem setting owner or group", e);
        }
    }

    public static void changePermissions(File fileOrDirectory, boolean recursive, Set<PosixFilePermission> permissions) {
        if (!fileOrDirectory.exists()) {
            throw new SmallToolsException("The file or directory " + fileOrDirectory.getAbsolutePath() + " does not exists");
        }
        try {
            Path path = fileOrDirectory.toPath();
            Files.setPosixFilePermissions(path, permissions);
            if (recursive && fileOrDirectory.isDirectory()) {
                for (File child : fileOrDirectory.listFiles()) {
                    FileTools.changePermissions(child, recursive, permissions);
                }
            }
        }
        catch (IOException e) {
            throw new SmallToolsException("Problem setting the permissions", e);
        }
    }

    public static void changePermissions(String fileOrDirectory, boolean recursive, String permissions) {
        File file = new File(fileOrDirectory);
        HashSet<PosixFilePermission> permissionsSet = new HashSet<PosixFilePermission>();
        if (permissions.length() != 3) {
            throw new SmallToolsException("The permissions must be like 777. Current: " + permissions);
        }
        String[] parts = new String[3];
        for (int i = 0; i < 3; ++i) {
            parts[i] = String.valueOf(permissions.charAt(i));
        }
        Integer ip = Integer.valueOf(parts[0]);
        if (FileTools.isPermRead(ip)) {
            permissionsSet.add(PosixFilePermission.OWNER_READ);
        }
        if (FileTools.isPermWrite(ip)) {
            permissionsSet.add(PosixFilePermission.OWNER_WRITE);
        }
        if (FileTools.isPermExecute(ip)) {
            permissionsSet.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if (FileTools.isPermRead(ip = Integer.valueOf(parts[1]))) {
            permissionsSet.add(PosixFilePermission.GROUP_READ);
        }
        if (FileTools.isPermWrite(ip)) {
            permissionsSet.add(PosixFilePermission.GROUP_WRITE);
        }
        if (FileTools.isPermExecute(ip)) {
            permissionsSet.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if (FileTools.isPermRead(ip = Integer.valueOf(parts[2]))) {
            permissionsSet.add(PosixFilePermission.OTHERS_READ);
        }
        if (FileTools.isPermWrite(ip)) {
            permissionsSet.add(PosixFilePermission.OTHERS_WRITE);
        }
        if (FileTools.isPermExecute(ip)) {
            permissionsSet.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        FileTools.changePermissions(file, recursive, permissionsSet);
    }

    public static void clearFile(File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void clearFile(String path) {
        FileTools.clearFile(new File(path));
    }

    protected static String concatPath(String ... pathParts) {
        StringBuilder sb = new StringBuilder();
        for (String pathPart : pathParts) {
            sb.append(pathPart);
        }
        return sb.toString();
    }

    public static void copyOwnerAndGroupFromParentDir(File fileOrDirectory, boolean recursive) {
        Path fileOrDirectoryPath = fileOrDirectory.toPath();
        Path parent = fileOrDirectoryPath.getParent();
        if (parent == null) {
            throw new SmallToolsException("There is no parent to " + fileOrDirectory.getAbsolutePath());
        }
        try {
            PosixFileAttributeView view = Files.getFileAttributeView(parent, PosixFileAttributeView.class, new LinkOption[0]);
            PosixFileAttributes attributes = view.readAttributes();
            UserPrincipal owner = attributes.owner();
            GroupPrincipal group = attributes.group();
            FileTools.changeOwnerAndGroup(fileOrDirectory, recursive, owner, group);
        }
        catch (IOException e) {
            throw new SmallToolsException("Problem setting owner or group", e);
        }
    }

    public static void copyOwnerAndGroupFromParentDir(String fileOrDirectory, boolean recursive) {
        FileTools.copyOwnerAndGroupFromParentDir(new File(fileOrDirectory), recursive);
    }

    public static RenamingOnCloseOutputStreamWrapper createStagingFile(File stagingFile, File finalFile) {
        try {
            FileOutputStream outputStream = new FileOutputStream(stagingFile);
            return new RenamingOnCloseOutputStreamWrapper(outputStream, stagingFile, finalFile);
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem creating the staging file", e);
        }
    }

    public static RenamingOnCloseOutputStreamWrapper createStagingFile(File stagingFile, File finalFile, boolean deleteOnClose) {
        try {
            FileOutputStream outputStream = new FileOutputStream(stagingFile);
            return new RenamingOnCloseOutputStreamWrapper(outputStream, stagingFile, finalFile, deleteOnClose);
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem creating the staging file", e);
        }
    }

    public static RenamingOnCloseOutputStreamWrapper createStagingFile(String stagingFileName, String finalFileName) {
        return FileTools.createStagingFile(new File(stagingFileName), new File(finalFileName));
    }

    public static RenamingOnCloseOutputStreamWrapper createStagingFile(String stagingFileName, String finalFileName, boolean deleteOnClose) {
        return FileTools.createStagingFile(new File(stagingFileName), new File(finalFileName), deleteOnClose);
    }

    public static boolean deleteFile(String path) {
        return new File(path).delete();
    }

    public static boolean exists(String file) {
        return new File(file).exists();
    }

    public static String getAbsolutePath(String workingDirectory, String filePath) {
        Object result = "";
        boolean backSlash = ((String)workingDirectory).contains("\\");
        if (backSlash) {
            workingDirectory = ((String)workingDirectory).replace("\\", "/");
        }
        if (!((String)workingDirectory).endsWith("/")) {
            workingDirectory = (String)workingDirectory + "/";
        }
        boolean windowsPath = FileTools.isWindowsStartPath((String)workingDirectory);
        if ((filePath = filePath.replace("\\", "/")).startsWith("/") || windowsPath && FileTools.isWindowsStartPath(filePath)) {
            result = filePath;
        } else {
            String root = "/";
            if (windowsPath) {
                root = ((String)workingDirectory).substring(0, 3);
            }
            Object current = ((String)workingDirectory).substring(root.length()) + filePath;
            current = DirectoryTools.cleanupDots((String)current);
            result = root + (String)current;
        }
        if (backSlash) {
            result = ((String)result).replace("/", "\\");
        }
        return result;
    }

    public static String getExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        int extPos = fileName.lastIndexOf(".");
        int slashPos = fileName.lastIndexOf("/");
        if (extPos == -1) {
            return null;
        }
        String ext = "";
        if (ext.length() <= extPos) {
            ext = fileName.substring(extPos + 1);
        }
        if (slashPos != -1 && slashPos > extPos) {
            return null;
        }
        return ext;
    }

    public static byte[] getFileAsBytes(File file) {
        try {
            return StreamsTools.consumeAsBytes(new FileInputStream(file));
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public static String getFileAsString(File file) {
        try {
            return StreamsTools.consumeAsString(new FileInputStream(file));
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public static String getFileAsString(String fileName) {
        try {
            return StreamsTools.consumeAsString(new FileInputStream(fileName));
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public static String getOwner(File file) {
        try {
            Path path = file.toPath();
            PosixFileAttributeView view = Files.getFileAttributeView(path, PosixFileAttributeView.class, new LinkOption[0]);
            return view.getOwner().getName();
        }
        catch (IOException e) {
            throw new SmallToolsException("Problem getting owner", e);
        }
    }

    public static String getOwner(String file) {
        return FileTools.getOwner(new File(file));
    }

    public static String getPermissions(String file) {
        try {
            int owner = 0;
            int group = 0;
            int others = 0;
            Set<PosixFilePermission> permissions = Files.getPosixFilePermissions(new File(file).toPath(), LinkOption.NOFOLLOW_LINKS);
            for (PosixFilePermission permission : permissions) {
                switch (permission) {
                    case GROUP_EXECUTE: {
                        ++group;
                        break;
                    }
                    case GROUP_READ: {
                        group += 4;
                        break;
                    }
                    case GROUP_WRITE: {
                        group += 2;
                        break;
                    }
                    case OTHERS_EXECUTE: {
                        ++others;
                        break;
                    }
                    case OTHERS_READ: {
                        others += 4;
                        break;
                    }
                    case OTHERS_WRITE: {
                        others += 2;
                        break;
                    }
                    case OWNER_EXECUTE: {
                        ++owner;
                        break;
                    }
                    case OWNER_READ: {
                        owner += 4;
                        break;
                    }
                    case OWNER_WRITE: {
                        owner += 2;
                    }
                }
            }
            return String.valueOf(owner) + String.valueOf(group) + String.valueOf(others);
        }
        catch (IOException e) {
            throw new SmallToolsException("Problem getting file permission", e);
        }
    }

    private static boolean isPermExecute(int perm) {
        return perm == 1 || perm == 3 || perm == 5 || perm == 7;
    }

    private static boolean isPermRead(int perm) {
        return perm >= 4;
    }

    private static boolean isPermWrite(int perm) {
        return perm == 2 || perm == 3 || perm == 6 || perm == 7;
    }

    public static boolean isWindowsStartPath(String path) {
        return path.matches("^[a-zA-Z]\\:[\\\\/].*$");
    }

    public static FileLinesIterable readFileLinesIteration(File file) throws FileNotFoundException {
        FileLinesIterable result = new FileLinesIterable();
        result.openFile(file);
        return result;
    }

    public static FileLinesIterable readFileLinesIteration(String filePath) {
        try {
            return FileTools.readFileLinesIteration(new File(filePath));
        }
        catch (FileNotFoundException e) {
            throw new SmallToolsException("Problem reading the file", e);
        }
    }

    public static Stream<String> readFileLinesStream(File file) {
        try {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(FileTools.readFileLinesIteration(file), 16), false);
        }
        catch (FileNotFoundException e) {
            throw new SmallToolsException("Could not open the file", e);
        }
    }

    public static Stream<String> readFileLinesStream(String filePath) {
        return FileTools.readFileLinesStream(new File(filePath));
    }

    public static boolean writeFile(byte[] content, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(content);
            fos.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void writeFile(byte[] content, String path) {
        FileTools.writeFile(content, new File(path));
    }

    public static boolean writeFile(InputStream inputStream, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            StreamsTools.flowStream(inputStream, fos);
            fos.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean writeFile(InputStream inputStream, File file, String permissions) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            StreamsTools.flowStream(inputStream, fos);
            fos.close();
            String path = file.getAbsolutePath();
            FileTools.changePermissions(path, false, permissions);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean writeFile(InputStream inputStream, File file, String owner, String group, String permissions) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            StreamsTools.flowStream(inputStream, fos);
            fos.close();
            String path = file.getAbsolutePath();
            FileTools.changeOwnerAndGroup(path, false, owner, group);
            FileTools.changePermissions(path, false, permissions);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean writeFile(String content, File file) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(content.getBytes(StandardCharsets.UTF_8));
            fos.close();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean writeFile(String content, File file, String permissions) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(content.getBytes(StandardCharsets.UTF_8));
            fos.close();
            String path = file.getAbsolutePath();
            FileTools.changePermissions(path, false, permissions);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static boolean writeFile(String content, File file, String owner, String group, String permissions) {
        try {
            FileOutputStream fos = new FileOutputStream(file);
            fos.write(content.getBytes(StandardCharsets.UTF_8));
            fos.close();
            String path = file.getAbsolutePath();
            FileTools.changeOwnerAndGroup(path, false, owner, group);
            FileTools.changePermissions(path, false, permissions);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public static void writeFile(String content, String path) {
        FileTools.writeFile(content, new File(path));
    }

    public static boolean writeFileWithContentCheck(String path, List<String> contentLines) {
        return FileTools.writeFileWithContentCheck(path, LINES_JOINER.join(contentLines));
    }

    public static boolean writeFileWithContentCheck(String path, List<String> contentLines, String permissions) {
        boolean needUpdate = FileTools.writeFileWithContentCheck(path, contentLines);
        FileTools.changePermissions(path, false, permissions);
        return needUpdate;
    }

    public static boolean writeFileWithContentCheck(String path, List<String> contentLines, String owner, String group, String permissions) {
        boolean needUpdate = FileTools.writeFileWithContentCheck(path, contentLines);
        FileTools.changeOwnerAndGroup(path, false, owner, group);
        FileTools.changePermissions(path, false, permissions);
        return needUpdate;
    }

    public static boolean writeFileWithContentCheck(String path, String content) {
        log.debug("writeFileWithContentCheck {}", (Object)path);
        boolean needUpdate = false;
        String contentMd5 = HashMd5sum.hashString(content);
        File file = new File(path);
        if (file.exists()) {
            String fileMd5 = HashMd5sum.hashFile(file);
            log.debug("Content md5 {} and file md5 {}", (Object)contentMd5, (Object)fileMd5);
            needUpdate = !contentMd5.equals(fileMd5);
        } else {
            log.debug("Is a new file");
            needUpdate = true;
        }
        if (needUpdate) {
            log.debug("Creating the file");
            if (!FileTools.writeFile(content, file)) {
                throw new SmallToolsException("Could not write the file " + path);
            }
        }
        return needUpdate;
    }

    public static boolean writeFileWithContentCheck(String path, String content, String permissions) {
        boolean needUpdate = FileTools.writeFileWithContentCheck(path, content);
        FileTools.changePermissions(path, false, permissions);
        return needUpdate;
    }

    public static boolean writeFileWithContentCheck(String path, String content, String owner, String group, String permissions) {
        boolean needUpdate = FileTools.writeFileWithContentCheck(path, content);
        FileTools.changeOwnerAndGroup(path, false, owner, group);
        FileTools.changePermissions(path, false, permissions);
        return needUpdate;
    }

    public static boolean writeFileWithContentCheck(String[] pathParts, List<String> contentLines, String permissions) {
        return FileTools.writeFileWithContentCheck(FileTools.concatPath(pathParts), contentLines, permissions);
    }

    public static boolean writeFileWithContentCheck(String[] pathParts, List<String> contentLines, String owner, String group, String permissions) {
        return FileTools.writeFileWithContentCheck(FileTools.concatPath(pathParts), contentLines, owner, group, permissions);
    }

    public static boolean writeFileWithContentCheck(String[] pathParts, String content, String permissions) {
        return FileTools.writeFileWithContentCheck(FileTools.concatPath(pathParts), content, permissions);
    }

    public static boolean writeFileWithContentCheck(String[] pathParts, String content, String owner, String group, String permissions) {
        return FileTools.writeFileWithContentCheck(FileTools.concatPath(pathParts), content, owner, group, permissions);
    }
}

