/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public final class DateTools {
    public static final ThreadLocal<SimpleDateFormat> sdfFull = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    public static final ThreadLocal<SimpleDateFormat> sdfDateOnly = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    public static final ThreadLocal<SimpleDateFormat> sdfTimeOnly = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("HH:mm:ss");
        }
    };

    public static Date addDate(Date date, int calendarUnit, int delta) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(calendarUnit, delta);
        return calendar.getTime();
    }

    public static Date addDate(int calendarUnit, int delta) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(calendarUnit, delta);
        return calendar.getTime();
    }

    public static String formatDateOnly(Date date) {
        if (date == null) {
            return null;
        }
        try {
            return sdfDateOnly.get().format(date);
        }
        catch (Exception e) {
            throw new SmallToolsException("Could not format [" + date + "] with date only format", e);
        }
    }

    public static String formatFull(Date date) {
        if (date == null) {
            return null;
        }
        try {
            return sdfFull.get().format(date);
        }
        catch (Exception e) {
            throw new SmallToolsException("Could not format [" + date + "] with full format", e);
        }
    }

    public static String formatTimeOnly(Date date) {
        if (date == null) {
            return null;
        }
        try {
            return sdfTimeOnly.get().format(date);
        }
        catch (Exception e) {
            throw new SmallToolsException("Could not format [" + date + "] with time only format", e);
        }
    }

    public static boolean isAfter(Date dateAfter, Date dateBefore) {
        return dateBefore.getTime() <= dateAfter.getTime();
    }

    public static boolean isBefore(Date dateBefore, Date dateAfter) {
        return dateBefore.getTime() <= dateAfter.getTime();
    }

    public static boolean isExpired(Date dateToCheck, Date currentTime, int calendarUnit, int delta) {
        Date expiresOn = DateTools.addDate(dateToCheck, calendarUnit, delta);
        return expiresOn.getTime() <= currentTime.getTime();
    }

    public static boolean isExpired(Date dateToCheck, int calendarUnit, int delta) {
        return DateTools.isExpired(dateToCheck, new Date(), calendarUnit, delta);
    }

    public static Date parseDateOnly(String date) {
        if (date == null) {
            return null;
        }
        try {
            return sdfDateOnly.get().parse(date);
        }
        catch (Exception e) {
            throw new SmallToolsException("Could not parse [" + date + "] with date only format", e);
        }
    }

    public static Date parseFull(String date) {
        if (date == null) {
            return null;
        }
        try {
            return sdfFull.get().parse(date);
        }
        catch (Exception e) {
            throw new SmallToolsException("Could not parse [" + date + "] with full format", e);
        }
    }

    public static Date parseTimeOnly(String date) {
        if (date == null) {
            return null;
        }
        try {
            return sdfTimeOnly.get().parse(date);
        }
        catch (Exception e) {
            throw new SmallToolsException("Could not parse [" + date + "] with time only format", e);
        }
    }

    private DateTools() {
    }
}

