/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.CloseableTools;
import com.foilen.smalltools.tools.StreamsTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.GZIPOutputStream;

public class CompressionTools {
    public static void gzipFileToFile(File source, File target) {
        GZIPOutputStream out = null;
        try {
            out = new GZIPOutputStream(new FileOutputStream(target));
            FileInputStream in = new FileInputStream(source);
            StreamsTools.flowStream(in, out);
        }
        catch (Exception e) {
            try {
                throw new SmallToolsException("Problem gzipping the file", e);
            }
            catch (Throwable throwable) {
                CloseableTools.close(out);
                throw throwable;
            }
        }
        CloseableTools.close(out);
    }

    public static void gzipFileToFile(File source, String target) {
        CompressionTools.gzipFileToFile(source, new File(target));
    }

    public static void gzipFileToFile(String source, File target) {
        CompressionTools.gzipFileToFile(new File(source), target);
    }

    public static void gzipFileToFile(String source, String target) {
        CompressionTools.gzipFileToFile(new File(source), new File(target));
    }

    private CompressionTools() {
    }
}

