/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.systemusage.implementations;

import com.foilen.smalltools.systemusage.implementations.MemoryUsageStrategy;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

public class MemoryUsageOsMxImpl
implements MemoryUsageStrategy {
    private OperatingSystemMXBean operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
    private Method systemFreeMemory;
    private Method systemTotalMemory;

    public MemoryUsageOsMxImpl() {
        Class<?> osbClass = this.operatingSystemBean.getClass();
        this.systemFreeMemory = this.getMethod(osbClass, "getFreePhysicalMemorySize");
        this.systemTotalMemory = this.getMethod(osbClass, "getTotalPhysicalMemorySize");
    }

    private Object callMethod(Method method) {
        try {
            return method.invoke((Object)this.operatingSystemBean, new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private Method getMethod(Class<?> type, String name) {
        try {
            Method method = type.getDeclaredMethod(name, new Class[0]);
            method.setAccessible(true);
            return method;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public Long getSystemFreeMemory() {
        Object result = this.callMethod(this.systemFreeMemory);
        if (result == null) {
            return null;
        }
        return (Long)result;
    }

    @Override
    public Long getSystemTotalMemory() {
        Object result = this.callMethod(this.systemTotalMemory);
        if (result == null) {
            return null;
        }
        return (Long)result;
    }

    @Override
    public Long getSystemUsedMemory() {
        Long free = this.getSystemFreeMemory();
        Long total = this.getSystemTotalMemory();
        if (free == null || total == null) {
            return null;
        }
        return total - free;
    }
}

