/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.systemusage;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.systemusage.results.CpuInfo;
import com.foilen.smalltools.systemusage.results.MemoryInfo;
import com.foilen.smalltools.systemusage.results.NetworkInfo;
import com.foilen.smalltools.tools.FileTools;
import com.foilen.smalltools.tools.SpaceConverterTools;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;

public final class ProcUsage {
    public static CpuInfo getMainCpuInfo(String procStatPath) {
        CpuInfo cpuInfo = new CpuInfo();
        boolean found = false;
        try (BufferedReader reader = new BufferedReader(new FileReader(procStatPath));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (!line.startsWith("cpu ")) continue;
                found = true;
                String[] parts = line.split("[ ]+");
                int i = 1;
                cpuInfo.setUser(Long.valueOf(parts[i++]));
                cpuInfo.setNice(Long.valueOf(parts[i++]));
                cpuInfo.setSystem(Long.valueOf(parts[i++]));
                cpuInfo.setIdle(Long.valueOf(parts[i++]));
                cpuInfo.setIowait(Long.valueOf(parts[i++]));
                cpuInfo.setIrq(Long.valueOf(parts[i++]));
                cpuInfo.setSoftirq(Long.valueOf(parts[i++]));
            }
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem reading the proc stat file", e);
        }
        if (!found) {
            throw new SmallToolsException("The file " + procStatPath + " is in the wrong format");
        }
        return cpuInfo;
    }

    public static MemoryInfo getMemoryInfo(String procMemPath) {
        MemoryInfo memoryInfo = new MemoryInfo();
        long memTotal = 0L;
        long memAvailable = 0L;
        long swapTotal = 0L;
        long swapFree = 0L;
        for (String line : FileTools.readFileLinesIteration(procMemPath)) {
            String[] parts = line.split("[ ]+", 2);
            if (parts.length != 2) continue;
            try {
                String name = parts[0];
                String size = parts[1];
                switch (name) {
                    case "MemTotal:": {
                        memTotal = SpaceConverterTools.convertToBytes(size);
                        memoryInfo.setPhysicalTotal(memTotal);
                        break;
                    }
                    case "MemAvailable:": {
                        memAvailable = SpaceConverterTools.convertToBytes(size);
                        break;
                    }
                    case "SwapTotal:": {
                        swapTotal = SpaceConverterTools.convertToBytes(size);
                        memoryInfo.setSwapTotal(swapTotal);
                    }
                    case "SwapFree:": {
                        swapFree = SpaceConverterTools.convertToBytes(size);
                    }
                }
            }
            catch (Exception e) {
                throw new SmallToolsException("Problem reading the proc meminfo file", e);
            }
        }
        memoryInfo.setPhysicalAvailable(memAvailable);
        memoryInfo.setPhysicalUsed(memTotal - memAvailable);
        memoryInfo.setSwapAvailable(swapFree);
        memoryInfo.setSwapUsed(swapTotal - swapFree);
        return memoryInfo;
    }

    public static List<NetworkInfo> getNetworkInfos(String procNetDevPath) {
        ArrayList<NetworkInfo> networkInfos = new ArrayList<NetworkInfo>();
        try (BufferedReader reader = new BufferedReader(new FileReader(procNetDevPath));){
            String line;
            reader.readLine();
            reader.readLine();
            while ((line = reader.readLine()) != null) {
                NetworkInfo networkInfo = new NetworkInfo();
                String[] parts = (line = line.trim()).split("[ ]+");
                if (parts.length != 17) continue;
                String interfaceName = parts[0];
                if (interfaceName.endsWith(":")) {
                    interfaceName = interfaceName.substring(0, interfaceName.length() - 1);
                }
                networkInfo.setInterfaceName(interfaceName);
                networkInfo.setInBytes(Long.valueOf(parts[1]));
                networkInfo.setInPackets(Long.valueOf(parts[2]));
                networkInfo.setOutBytes(Long.valueOf(parts[9]));
                networkInfo.setOutPackets(Long.valueOf(parts[10]));
                networkInfos.add(networkInfo);
            }
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem reading the proc dev net file", e);
        }
        return networkInfos;
    }
}

