/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.systemusage;

import java.io.File;

public class FileSystemUsage {
    public static FileSystemInfo[] getRootFileSystemInfos() {
        File[] roots = File.listRoots();
        FileSystemInfo[] result = new FileSystemInfo[roots.length];
        int i = 0;
        for (File root : roots) {
            result[i++] = new FileSystemInfo(root);
        }
        return result;
    }

    public static void main(String[] args) {
        for (FileSystemInfo fsi : FileSystemUsage.getRootFileSystemInfos()) {
            System.out.println("Path: " + fsi.getFile().getAbsolutePath());
            System.out.println("Free space: " + fsi.getFreeSpace() + " " + fsi.getFreeSpacePercent() + "%");
            System.out.println("Used space: " + fsi.getUsedSpace() + " " + fsi.getUsedSpacePercent() + "%");
            System.out.println("Total space: " + fsi.getTotalSpace());
            System.out.println();
        }
    }

    private FileSystemUsage() {
    }

    public static class FileSystemInfo {
        private File file;

        public FileSystemInfo(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }

        public long getFreeSpace() {
            return this.file.getUsableSpace();
        }

        public double getFreeSpacePercent() {
            long totalSpace = this.getTotalSpace();
            if (totalSpace == 0L) {
                return 0.0;
            }
            return (double)this.getFreeSpace() * 100.0 / (double)totalSpace;
        }

        public long getTotalSpace() {
            return this.file.getTotalSpace();
        }

        public long getUsedSpace() {
            return this.getTotalSpace() - this.getFreeSpace();
        }

        public double getUsedSpacePercent() {
            long totalSpace = this.getTotalSpace();
            if (totalSpace == 0L) {
                return 0.0;
            }
            return (double)this.getUsedSpace() * 100.0 / (double)totalSpace;
        }
    }
}

