/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.shell;

import com.foilen.smalltools.iterable.FileLinesIterable;
import com.foilen.smalltools.shell.ExecResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ExecResultInMemory
implements ExecResult {
    private ByteArrayOutputStream out;
    private ByteArrayOutputStream err;
    private int exitCode;

    public ExecResultInMemory(ByteArrayOutputStream out, ByteArrayOutputStream err, int exitCode) {
        this.out = out;
        this.err = err;
        this.exitCode = exitCode;
    }

    public ByteArrayOutputStream getErr() {
        return this.err;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    public ByteArrayOutputStream getOut() {
        return this.out;
    }

    @Override
    public InputStream getStdErrAsInputStream() {
        return new ByteArrayInputStream(this.err.toByteArray());
    }

    @Override
    public Stream<String> getStdErrAsLines() {
        FileLinesIterable linesIterable = new FileLinesIterable();
        linesIterable.openStream(this.getStdErrAsInputStream());
        return StreamSupport.stream(linesIterable.spliterator(), false);
    }

    @Override
    public String getStdErrAsString() {
        return this.err.toString();
    }

    @Override
    public InputStream getStdOutAsInputStream() {
        return new ByteArrayInputStream(this.out.toByteArray());
    }

    @Override
    public Stream<String> getStdOutAsLines() {
        FileLinesIterable linesIterable = new FileLinesIterable();
        linesIterable.openStream(this.getStdOutAsInputStream());
        return StreamSupport.stream(linesIterable.spliterator(), false);
    }

    @Override
    public String getStdOutAsString() {
        return this.out.toString();
    }
}

