/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.iterable;

import com.foilen.smalltools.exception.SmallToolsException;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;

public class FileLinesIterable
implements Iterable<String>,
Iterator<String> {
    private BufferedReader bufferedReader;
    private String nextLine;

    private void close() {
        try {
            this.bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean hasNext() {
        return this.nextLine != null;
    }

    @Override
    public Iterator<String> iterator() {
        return this;
    }

    @Override
    public String next() {
        String result = this.nextLine;
        this.readNextLine();
        return result;
    }

    public void openFile(File file) throws FileNotFoundException {
        this.bufferedReader = new BufferedReader(new FileReader(file));
        this.readNextLine();
    }

    public void openStream(InputStream inputStream) {
        this.bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        this.readNextLine();
    }

    public void openString(String text) {
        this.openStream(new ByteArrayInputStream(text.getBytes(StandardCharsets.UTF_8)));
    }

    private void readNextLine() {
        try {
            this.nextLine = this.bufferedReader.readLine();
            if (this.nextLine == null) {
                this.close();
            }
        }
        catch (IOException e) {
            this.close();
            throw new SmallToolsException(e);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

