/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.hash;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.EncodingTools;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class HashUtils {
    private static final int BUFFER_SIZE = 1024;

    public static String hashInputStream(String algorithm, InputStream in) {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SmallToolsException(e);
        }
        try {
            int len;
            byte[] bytes = new byte[1024];
            while ((len = in.read(bytes)) != -1) {
                messageDigest.update(bytes, 0, len);
            }
        }
        catch (Exception e) {
            throw new SmallToolsException("Issue hashing the stream", e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception exception) {}
        }
        byte[] digest = messageDigest.digest();
        return EncodingTools.toHex(digest);
    }
}

