/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.filesystemupdatewatcher.handler;

import com.foilen.smalltools.filesystemupdatewatcher.FileSystemUpdateBufferedHandler;
import com.foilen.smalltools.filesystemupdatewatcher.FileSystemUpdateHandler;
import com.foilen.smalltools.filesystemupdatewatcher.FileSystemUpdateWatcher;
import com.foilen.smalltools.filesystemupdatewatcher.handler.OneFileUpdateNotifyerHandler;
import com.foilen.smalltools.tools.CloseableTools;
import java.io.Closeable;
import java.io.File;

public class OneFileUpdateNotifyer
implements Closeable,
FileSystemUpdateHandler {
    private String fileToWatch;
    private File fileToWatchFile;
    private OneFileUpdateNotifyerHandler handler;
    private FileSystemUpdateWatcher fileSystemUpdateWatcher;

    public OneFileUpdateNotifyer(String fileToWatch, OneFileUpdateNotifyerHandler handler) {
        this.fileToWatch = fileToWatch;
        this.fileToWatchFile = new File(fileToWatch);
        this.handler = handler;
    }

    @Override
    public void close() {
        CloseableTools.close(this.fileSystemUpdateWatcher);
    }

    @Override
    public void created(File file) {
        if (file.equals(this.fileToWatchFile)) {
            this.handler.fileUpdated(this.fileToWatch);
        }
    }

    @Override
    public void deleted(File file) {
        if (file.equals(this.fileToWatchFile)) {
            this.handler.fileUpdated(this.fileToWatch);
        }
    }

    public void initAutoUpdateSystem() {
        this.handler.fileUpdated(this.fileToWatch);
        this.fileSystemUpdateWatcher = new FileSystemUpdateWatcher(this.fileToWatchFile.getParentFile().getAbsolutePath());
        this.fileSystemUpdateWatcher.addHandler(new FileSystemUpdateBufferedHandler(this, 2000L, 10000L));
        this.fileSystemUpdateWatcher.init();
    }

    @Override
    public void modified(File file) {
        if (file.equals(this.fileToWatchFile)) {
            this.handler.fileUpdated(this.fileToWatch);
        }
    }
}

