/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.upgrader;

import com.foilen.smalltools.comparator.ClassNameComparator;
import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.AssertTools;
import com.foilen.smalltools.upgrader.tasks.UpgradeTask;
import com.foilen.smalltools.upgrader.trackers.UpgraderTracker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgraderTools {
    private static final Logger logger = LoggerFactory.getLogger(UpgraderTools.class);
    private UpgraderTracker defaultUpgraderTracker;
    private Map<String, UpgraderTracker> upgraderTrackerByName = new HashMap<String, UpgraderTracker>();
    private List<UpgradeTask> tasks = new ArrayList<UpgradeTask>();
    private boolean sortByClassName = true;

    public UpgraderTools() {
    }

    public UpgraderTools(List<UpgradeTask> tasks) {
        this.tasks = tasks;
    }

    public UpgraderTools addUpgraderTracker(String trackerName, UpgraderTracker upgraderTracker) {
        this.upgraderTrackerByName.put(trackerName, upgraderTracker);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void execute() throws Exception {
        logger.info("Starting upgrades");
        if (this.sortByClassName) {
            Collections.sort(this.tasks, new ClassNameComparator());
        }
        ArrayList<UpgraderTracker> allTrackers = new ArrayList<UpgraderTracker>();
        if (this.defaultUpgraderTracker != null) {
            allTrackers.add(this.defaultUpgraderTracker);
        }
        allTrackers.addAll(this.upgraderTrackerByName.values());
        AssertTools.assertFalse(allTrackers.isEmpty(), "There are no upgrade tracker set");
        allTrackers.forEach(it -> it.trackerBegin());
        int count = 1;
        SmallToolsException failure = null;
        for (UpgradeTask task : this.tasks) {
            UpgraderTracker upgraderTracker;
            String trackerName = task.useTracker();
            if ("____".equals(trackerName)) {
                upgraderTracker = this.defaultUpgraderTracker;
                AssertTools.assertNotNull(upgraderTracker, "There is no default upgrade tracker set");
            } else {
                upgraderTracker = this.upgraderTrackerByName.get(trackerName);
                AssertTools.assertNotNull(upgraderTracker, "There is no upgrade tracker with name: " + trackerName);
            }
            String taskSimpleName = task.getClass().getSimpleName();
            if (upgraderTracker.wasExecutedSuccessfully(taskSimpleName)) {
                logger.info("[{}/{}] Skipping {} . Already executed", new Object[]{count, this.tasks.size(), taskSimpleName});
                ++count;
                continue;
            }
            logger.info("[{}/{}] Begin {}", new Object[]{count, this.tasks.size(), taskSimpleName});
            upgraderTracker.executionBegin(taskSimpleName);
            try {
                task.execute();
                upgraderTracker.executionEnd(taskSimpleName, failure == null);
            }
            catch (Throwable e) {
                try {
                    logger.error("[{}/{}] Problem executing upgrade task {}", new Object[]{count, this.tasks.size(), task.getClass().getSimpleName(), e});
                    failure = new SmallToolsException("Problem executing upgrade task " + task.getClass().getSimpleName(), e);
                    upgraderTracker.executionEnd(taskSimpleName, failure == null);
                    break;
                }
                catch (Throwable throwable) {
                    upgraderTracker.executionEnd(taskSimpleName, failure == null);
                    throw throwable;
                }
            }
            logger.info("[{}/{}] Completed {}", new Object[]{count, this.tasks.size(), task.getClass().getSimpleName()});
            ++count;
        }
        allTrackers.forEach(it -> it.trackerEnd());
        if (failure != null) {
            throw failure;
        }
        logger.info("Upgrades completed");
    }

    public UpgraderTracker getDefaultUpgraderTracker() {
        return this.defaultUpgraderTracker;
    }

    public List<UpgradeTask> getTasks() {
        return this.tasks;
    }

    public Map<String, UpgraderTracker> getUpgraderTrackerByName() {
        return this.upgraderTrackerByName;
    }

    public boolean isSortByClassName() {
        return this.sortByClassName;
    }

    public void setDefaultUpgraderTracker(UpgraderTracker defaultUpgraderTracker) {
        this.defaultUpgraderTracker = defaultUpgraderTracker;
    }

    public void setSortByClassName(boolean sortByClassName) {
        this.sortByClassName = sortByClassName;
    }

    public void setTasks(List<UpgradeTask> tasks) {
        this.tasks = tasks;
    }

    public void setUpgraderTrackerByName(Map<String, UpgraderTracker> upgraderTrackerByName) {
        this.upgraderTrackerByName = upgraderTrackerByName;
    }
}

