/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools.thread;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ThreadList {
    private List<Thread> threads = new ArrayList<Thread>();

    public ThreadList() {
    }

    public ThreadList(List<Thread> threads) {
        this.threads = threads;
    }

    public ThreadList(Runnable ... runnables) {
        this.addAll(runnables);
    }

    public ThreadList(Thread ... threads) {
        this.addAll(threads);
    }

    public void add(Runnable runnable) {
        this.threads.add(new Thread(runnable));
    }

    public void add(Thread thread) {
        this.threads.add(thread);
    }

    public void addAll(Collection<Runnable> runnables) {
        for (Runnable runnable : runnables) {
            this.add(runnable);
        }
    }

    public void addAll(Runnable ... runnables) {
        for (Runnable runnable : runnables) {
            this.add(runnable);
        }
    }

    public void addAll(Thread ... threads) {
        for (Thread thread : threads) {
            this.add(thread);
        }
    }

    public boolean areAllAlive() {
        for (Thread thread : this.threads) {
            if (thread.isAlive()) continue;
            return false;
        }
        return true;
    }

    public int countActive() {
        int count = 0;
        for (Thread thread : this.threads) {
            if (!thread.isAlive()) continue;
            ++count;
        }
        return count;
    }

    public List<Thread> getThreads() {
        return this.threads;
    }

    public void interrupt() {
        this.threads.forEach(it -> it.interrupt());
    }

    public boolean isAnyAlive() {
        for (Thread thread : this.threads) {
            if (!thread.isAlive()) continue;
            return true;
        }
        return false;
    }

    public void join() throws InterruptedException {
        for (Thread thread : this.threads) {
            thread.join();
        }
    }

    public void join(long millis) throws InterruptedException {
        long timeoutAt = System.currentTimeMillis() + millis;
        for (Thread thread : this.threads) {
            long now = System.currentTimeMillis();
            if (now >= timeoutAt) {
                return;
            }
            thread.join(timeoutAt - now);
        }
    }

    public void setDaemon(boolean isDaemon) {
        this.threads.forEach(it -> it.setDaemon(isDaemon));
    }

    public void setThreads(List<Thread> threads) {
        this.threads = threads;
    }

    public void start() {
        this.threads.forEach(it -> it.start());
    }
}

