/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.reflection.ReflectionTools;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.error.YAMLException;

public final class YamlTools {
    private static final Yaml COMPACT_YAML;
    private static final Yaml PRETTY_YAML;

    public static <T> T clone(T object) {
        if (object == null) {
            return null;
        }
        Class<?> type = object.getClass();
        String yaml = YamlTools.compactPrint(object);
        return (T)YamlTools.readFromString(yaml, type);
    }

    public static String compactPrint(Object object) {
        try {
            return COMPACT_YAML.dump(object);
        }
        catch (YAMLException e) {
            throw new SmallToolsException("Problem serializing in Yaml", e);
        }
    }

    public static String prettyPrint(Object object) {
        try {
            return PRETTY_YAML.dump(object);
        }
        catch (YAMLException e) {
            throw new SmallToolsException("Problem serializing in Yaml", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T readFromFile(File file, Class<T> clazz) {
        try (FileReader reader = new FileReader(file);){
            Object object = PRETTY_YAML.loadAs((Reader)reader, clazz);
            return (T)object;
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem deserializing from Yaml", e);
        }
    }

    public static void readFromFile(File file, Object target) {
        Object readObject = YamlTools.readFromFile(file, target.getClass());
        ReflectionTools.copyAllProperties(readObject, target);
    }

    public static <T> T readFromFile(String fileName, Class<T> clazz) {
        return YamlTools.readFromFile(new File(fileName), clazz);
    }

    public static void readFromFile(String fileName, Object target) {
        YamlTools.readFromFile(new File(fileName), target);
    }

    public static <T> T readFromResource(String resource, Class<T> clazz) {
        return YamlTools.readFromResource(resource, clazz, YamlTools.class);
    }

    public static <T> T readFromResource(String resource, Class<T> clazz, Class<?> context) {
        try {
            return (T)PRETTY_YAML.loadAs(context.getResourceAsStream(resource), clazz);
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem deserializing from Yaml", e);
        }
    }

    public static <T> T readFromString(String text, Class<T> clazz) {
        try {
            return (T)PRETTY_YAML.loadAs(text, clazz);
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem deserializing from Yaml", e);
        }
    }

    public static void writeToFile(File file, Object object) {
        try (FileWriter output = new FileWriter(file);){
            PRETTY_YAML.dump(object, (Writer)output);
        }
        catch (IOException e) {
            throw new SmallToolsException("Problem serializing in Yaml", e);
        }
    }

    public static void writeToFile(String fileName, Object object) {
        YamlTools.writeToFile(new File(fileName), object);
    }

    public static void writeToStream(OutputStream stream, Object object) {
        try {
            PRETTY_YAML.dump(object, (Writer)new OutputStreamWriter(stream));
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem serializing in Yaml", e);
        }
    }

    public static String writeToString(Object object) {
        try {
            return PRETTY_YAML.dump(object);
        }
        catch (YAMLException e) {
            throw new SmallToolsException("Problem serializing in Yaml", e);
        }
    }

    private YamlTools() {
    }

    static {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setPrettyFlow(true);
        PRETTY_YAML = new Yaml(dumperOptions);
        COMPACT_YAML = new Yaml();
    }
}

