/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.ThreadNameStateTool;
import com.foilen.smalltools.tools.thread.ThreadList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;

public final class ThreadTools {
    public static ThreadFactory daemonThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                return thread;
            }
        };
    }

    public static ThreadFactory daemonThreadFactory(final Consumer<Thread> consumer) {
        return new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread thread = new Thread(r);
                thread.setDaemon(true);
                consumer.accept(thread);
                return thread;
            }
        };
    }

    public static Optional<String> getStackMethodName(Class<?> onClass) {
        String onClassName = onClass.getName();
        for (StackTraceElement element : Thread.currentThread().getStackTrace()) {
            if (!element.getClassName().equals(onClassName)) continue;
            return Optional.of(element.getMethodName());
        }
        return Optional.empty();
    }

    public static ThreadNameStateTool nameThread() {
        return new ThreadNameStateTool();
    }

    public static void printAllStackTraces() {
        for (Map.Entry<Thread, StackTraceElement[]> entry : Thread.getAllStackTraces().entrySet()) {
            System.out.println(entry.getKey().getName());
            ThreadTools.printStackTrace(entry.getValue());
            System.out.println();
        }
    }

    public static void printStackTrace(StackTraceElement[] stackTraceElements) {
        for (StackTraceElement stackTraceElement : stackTraceElements) {
            System.out.println(stackTraceElement);
        }
    }

    public static void printStackTrace(Thread thread) {
        ThreadTools.printStackTrace(thread.getStackTrace());
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new SmallToolsException("Sleeping interupted", e);
        }
    }

    public static ThreadList startMultipleThreads(boolean isDaemon, Runnable ... runnables) {
        ThreadList threadList = new ThreadList();
        threadList.addAll(runnables);
        threadList.setDaemon(isDaemon);
        threadList.start();
        return threadList;
    }

    private ThreadTools() {
    }
}

