/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.EndOfStreamException;
import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.AssertTools;
import com.foilen.smalltools.tools.CharsetTools;
import com.foilen.smalltools.tools.CloseableTools;
import com.foilen.smalltools.tools.ThreadTools;
import com.foilen.smalltools.tools.internal.FlowStreamThread;
import com.foilen.smalltools.tuple.Tuple2;
import com.google.common.primitives.Ints;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public final class StreamsTools {
    private static final Logger logger = LoggerFactory.getLogger(StreamsTools.class);
    private static final int BUFFER_SIZE = 1024;

    public static byte[] consumeAsBytes(InputStream input) {
        AssertTools.assertNotNull(input, "The input cannot be null");
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StreamsTools.flowStream(input, outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        finally {
            CloseableTools.close(input);
        }
    }

    public static String consumeAsString(InputStream input) {
        AssertTools.assertNotNull(input, "The input cannot be null");
        try {
            int len;
            InputStreamReader reader = new InputStreamReader(input, CharsetTools.UTF_8);
            StringBuilder sb = new StringBuilder();
            char[] chars = new char[1024];
            while ((len = reader.read(chars)) != -1) {
                sb.append(chars, 0, len);
            }
            String string = sb.toString();
            return string;
        }
        catch (Exception e) {
            throw new SmallToolsException("Issue reading the stream", e);
        }
        finally {
            CloseableTools.close(input);
        }
    }

    public static OutputStream createLoggerOutputStream(Logger outputLogger, Level level) {
        AssertTools.assertNotNull(outputLogger, "The Logger cannot be null");
        AssertTools.assertNotNull(level, "The Level cannot be null");
        Tuple2<PipedInputStream, PipedOutputStream> pipe = StreamsTools.createPipe();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(pipe.getA()));
        new Thread(() -> {
            ThreadTools.nameThread().setSeparator(" - ").clear().appendText("OutputStream pipe to Logger").appendDate().change();
            try {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    switch (level) {
                        case DEBUG: {
                            outputLogger.debug(line);
                            break;
                        }
                        case ERROR: {
                            outputLogger.error(line);
                            break;
                        }
                        case INFO: {
                            outputLogger.info(line);
                            break;
                        }
                        case TRACE: {
                            outputLogger.trace(line);
                            break;
                        }
                        case WARN: {
                            outputLogger.warn(line);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.error("Error while reading the output stream", (Throwable)e);
            }
            finally {
                CloseableTools.close(bufferedReader);
            }
        }).start();
        return pipe.getB();
    }

    public static Tuple2<PipedInputStream, PipedOutputStream> createPipe() {
        try {
            PipedInputStream pipedInputStream = new PipedInputStream();
            PipedOutputStream pipedOutputStream = new PipedOutputStream(pipedInputStream);
            return new Tuple2<PipedInputStream, PipedOutputStream>(pipedInputStream, pipedOutputStream);
        }
        catch (IOException e) {
            throw new SmallToolsException("Problem creating pipe", e);
        }
    }

    private static void fillBuffer(InputStream source, byte[] buffer) {
        int needed = buffer.length;
        int totalRead = 0;
        try {
            int len = source.read(buffer);
            totalRead += len;
            while (totalRead != needed) {
                logger.debug("Read {} bytes. Total read {} and need {}", new Object[]{len, totalRead, needed});
                if (len == -1) {
                    throw new EndOfStreamException(totalRead >= 0, "End of Stream");
                }
                len = source.read(buffer, totalRead, needed - totalRead);
                totalRead += len;
            }
            logger.debug("Completly read {} bytes.", (Object)totalRead);
        }
        catch (IOException e) {
            throw new SmallToolsException("Issue reading from the stream", e);
        }
    }

    public static FlowStreamThread flowAndCloseStreamNonBlocking(InputStream source, OutputStream destination) {
        FlowStreamThread thread = new FlowStreamThread(source, destination, true);
        thread.start();
        return thread;
    }

    public static FlowStreamThread flowAndCloseStreamNonBlocking(InputStream source, OutputStream destination, String threadName) {
        FlowStreamThread thread = new FlowStreamThread(source, destination, true);
        thread.setName(threadName);
        thread.start();
        return thread;
    }

    public static void flowStream(InputStream source, OutputStream destination) {
        StreamsTools.flowStream(source, destination, true);
    }

    public static void flowStream(InputStream source, OutputStream destination, boolean closeSource) {
        AssertTools.assertNotNull(source, "The source cannot be null");
        AssertTools.assertNotNull(destination, "The destination cannot be null");
        try {
            int len;
            byte[] bytes = new byte[1024];
            logger.debug("Starting to copy the stream");
            while ((len = source.read(bytes)) != -1) {
                destination.write(bytes, 0, len);
                if (source.available() != 0) continue;
                destination.flush();
            }
            logger.debug("Copy completed");
        }
        catch (Exception e) {
            throw new SmallToolsException("Issue copying the stream", e);
        }
        finally {
            if (closeSource) {
                CloseableTools.close(source);
            }
        }
    }

    public static FlowStreamThread flowStreamNonBlocking(InputStream source, OutputStream destination) {
        FlowStreamThread thread = new FlowStreamThread(source, destination, false);
        thread.start();
        return thread;
    }

    public static FlowStreamThread flowStreamNonBlocking(InputStream source, OutputStream destination, boolean closeAtEnd) {
        FlowStreamThread thread = new FlowStreamThread(source, destination, closeAtEnd);
        thread.start();
        return thread;
    }

    public static FlowStreamThread flowStreamNonBlocking(InputStream source, OutputStream destination, boolean closeAtEnd, String threadName) {
        FlowStreamThread thread = new FlowStreamThread(source, destination, closeAtEnd);
        thread.setName(threadName);
        thread.start();
        return thread;
    }

    public static FlowStreamThread flowStreamNonBlocking(InputStream source, OutputStream destination, String threadName) {
        FlowStreamThread thread = new FlowStreamThread(source, destination, false);
        thread.setName(threadName);
        thread.start();
        return thread;
    }

    public static byte[] readBytes(InputStream source) {
        byte[] lenBytes = new byte[4];
        StreamsTools.fillBuffer(source, lenBytes);
        int len = Ints.fromByteArray((byte[])lenBytes);
        byte[] content = new byte[len];
        StreamsTools.fillBuffer(source, content);
        return content;
    }

    public static byte[] readBytes(InputStream source, int maxLength) {
        byte[] lenBytes = new byte[4];
        StreamsTools.fillBuffer(source, lenBytes);
        int len = Ints.fromByteArray((byte[])lenBytes);
        AssertTools.assertTrue(len <= maxLength, "The length is bigger than the expected length");
        AssertTools.assertTrue(len > 0, "The length is smaller than 1");
        byte[] content = new byte[len];
        try {
            StreamsTools.fillBuffer(source, content);
        }
        catch (EndOfStreamException e) {
            throw new EndOfStreamException(true, e.getMessage());
        }
        return content;
    }

    public static int readInt(InputStream source) {
        try {
            byte[] value = new byte[4];
            AssertTools.assertTrue(source.read(value) == 4, "Could not read the value");
            return Ints.fromByteArray((byte[])value);
        }
        catch (IOException e) {
            throw new SmallToolsException("Issue reading from the stream", e);
        }
    }

    public static String readString(InputStream source) {
        byte[] bytes = StreamsTools.readBytes(source);
        return new String(bytes, CharsetTools.UTF_8);
    }

    public static String readString(InputStream source, int maxLength) {
        byte[] bytes = StreamsTools.readBytes(source, maxLength);
        return new String(bytes, CharsetTools.UTF_8);
    }

    public static void write(OutputStream destination, byte[] content) {
        try {
            destination.write(Ints.toByteArray((int)content.length));
            destination.write(content);
            destination.flush();
        }
        catch (IOException e) {
            throw new SmallToolsException("Issue writing to the stream", e);
        }
    }

    public static void write(OutputStream destination, int value) {
        try {
            destination.write(Ints.toByteArray((int)value));
            destination.flush();
        }
        catch (IOException e) {
            throw new SmallToolsException("Issue writing to the stream", e);
        }
    }

    public static void write(OutputStream destination, String content) {
        StreamsTools.write(destination, content.getBytes(CharsetTools.UTF_8));
    }

    private StreamsTools() {
    }
}

