/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SingleDependencyResolverTools {
    private Map<String, Item> itemByName = new HashMap<String, Item>();
    private List<Item> roots = new ArrayList<Item>();
    private List<String> hasDependency = new ArrayList<String>();

    public SingleDependencyResolverTools addDependency(String item, String dependsOnItem) {
        if (this.hasDependency.contains(item)) {
            throw new SmallToolsException("Item " + item + " already has one dependency");
        }
        this.hasDependency.add(item);
        boolean isDepending = !Strings.isNullOrEmpty((String)dependsOnItem);
        Item currentItem = this.itemByName.get(item);
        if (currentItem == null) {
            currentItem = new Item();
            currentItem.name = item;
            this.itemByName.put(item, currentItem);
            if (!isDepending) {
                this.roots.add(currentItem);
            }
        } else if (isDepending) {
            this.roots.remove(currentItem);
        }
        if (isDepending) {
            Item depended = this.itemByName.get(dependsOnItem);
            if (depended == null) {
                depended = new Item();
                depended.name = dependsOnItem;
                this.itemByName.put(dependsOnItem, depended);
                this.roots.add(depended);
            }
            depended.dependedBy.add(currentItem);
        }
        return this;
    }

    public List<String> getExecution() {
        ArrayList<String> executionPlan = new ArrayList<String>();
        for (Item item : this.roots) {
            this.visit(executionPlan, item);
        }
        if (executionPlan.size() != this.itemByName.size()) {
            throw new SmallToolsException("Has a circular dependency");
        }
        return executionPlan;
    }

    private void visit(List<String> executionPlan, Item item) {
        executionPlan.add(item.name);
        for (Item child : item.dependedBy) {
            this.visit(executionPlan, child);
        }
    }

    private class Item {
        public String name;
        public List<Item> dependedBy = new ArrayList<Item>();

        private Item() {
        }
    }
}

