/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.reflection.ReflectionTools;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;

public final class JsonTools {
    private static final ObjectMapper COMPACT_OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectMapper COMPACT_SKIPNULL_OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectMapper PRETTY_OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectMapper PRETTY_SKIPNULL_OBJECT_MAPPER = new ObjectMapper();
    private static final ObjectMapper NON_FAIL_OBJECT_MAPPER = new ObjectMapper();

    public static <T> T clone(Object object, Class<T> clazz) {
        if (object == null) {
            return null;
        }
        String json = JsonTools.compactPrint(object);
        return JsonTools.readFromString(json, clazz);
    }

    public static <T> T clone(T object) {
        if (object == null) {
            return null;
        }
        Class<?> type = object.getClass();
        String json = JsonTools.compactPrint(object);
        return (T)JsonTools.readFromString(json, type);
    }

    public static <T> SortedMap<String, Object> cloneAsSortedMap(T object) {
        if (object == null) {
            return null;
        }
        SortedMap sortedMap = JsonTools.clone(object, SortedMap.class);
        JsonTools.convertAllMapsToSortedMap(sortedMap);
        return sortedMap;
    }

    public static String compactPrint(Object object) {
        try {
            return COMPACT_OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new SmallToolsException("Problem serializing in JSON", e);
        }
    }

    public static String compactPrintWithoutNulls(Object object) {
        try {
            return COMPACT_SKIPNULL_OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new SmallToolsException("Problem serializing in JSON", e);
        }
    }

    private static void convertAllMapsToSortedMap(SortedMap<String, Object> sortedMap) {
        for (String key : sortedMap.keySet().stream().collect(Collectors.toList())) {
            Object value = sortedMap.get(key);
            if (value instanceof Map) {
                Map subMap = (Map)value;
                TreeMap<String, Object> subSortedMap = new TreeMap<String, Object>(subMap);
                sortedMap.put(key, subSortedMap);
                JsonTools.convertAllMapsToSortedMap(subSortedMap);
                continue;
            }
            if (!(value instanceof List)) continue;
            List subList = (List)value;
            for (int i = 0; i < subList.size(); ++i) {
                Object item = subList.get(i);
                if (!(item instanceof Map)) continue;
                subList.set(i, new TreeMap((Map)item));
            }
        }
    }

    public static String prettyPrint(Object object) {
        try {
            return PRETTY_OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new SmallToolsException("Problem serializing in JSON", e);
        }
    }

    public static String prettyPrintWithoutNulls(Object object) {
        try {
            return PRETTY_SKIPNULL_OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new SmallToolsException("Problem serializing in JSON", e);
        }
    }

    public static <T> T readFromFile(File file, Class<T> clazz) {
        try {
            return (T)PRETTY_OBJECT_MAPPER.readValue(file, clazz);
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem deserializing from JSON", e);
        }
    }

    public static void readFromFile(File file, Object target) {
        Object readObject = JsonTools.readFromFile(file, target.getClass());
        ReflectionTools.copyAllProperties(readObject, target);
    }

    public static <T> T readFromFile(String fileName, Class<T> clazz) {
        return JsonTools.readFromFile(new File(fileName), clazz);
    }

    public static void readFromFile(String fileName, Object target) {
        JsonTools.readFromFile(new File(fileName), target);
    }

    public static <T> List<T> readFromFileAsList(File file, Class<T> clazz) {
        try {
            CollectionType listType = PRETTY_OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, clazz);
            return (List)PRETTY_OBJECT_MAPPER.readValue(file, (JavaType)listType);
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem deserializing from JSON", e);
        }
    }

    public static <T> List<T> readFromFileAsList(String fileName, Class<T> clazz) {
        return JsonTools.readFromFileAsList(new File(fileName), clazz);
    }

    public static <T> T readFromFileIgnoreFail(File file, Class<T> clazz) {
        try {
            return (T)NON_FAIL_OBJECT_MAPPER.readValue(file, clazz);
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem deserializing from JSON", e);
        }
    }

    public static void readFromFileIgnoreFail(File file, Object target) {
        Object readObject = JsonTools.readFromFileIgnoreFail(file, target.getClass());
        ReflectionTools.copyAllProperties(readObject, target);
    }

    public static void readFromFileIgnoreFail(String fileName, Object target) {
        JsonTools.readFromFileIgnoreFail(new File(fileName), target);
    }

    public static <T> T readFromResource(String resource, Class<T> clazz) {
        return JsonTools.readFromResource(resource, clazz, JsonTools.class);
    }

    public static <T> T readFromResource(String resource, Class<T> clazz, Class<?> context) {
        try {
            return (T)PRETTY_OBJECT_MAPPER.readValue(context.getResourceAsStream(resource), clazz);
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem deserializing from JSON", e);
        }
    }

    public static <T> List<T> readFromResourceAsList(String resource, Class<T> clazz) {
        return JsonTools.readFromResourceAsList(resource, clazz, JsonTools.class);
    }

    public static <T> List<T> readFromResourceAsList(String resource, Class<T> clazz, Class<?> context) {
        try {
            CollectionType listType = PRETTY_OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, clazz);
            return (List)PRETTY_OBJECT_MAPPER.readValue(context.getResourceAsStream(resource), (JavaType)listType);
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem deserializing from JSON", e);
        }
    }

    public static <T> T readFromString(String text, Class<T> clazz) {
        try {
            return (T)PRETTY_OBJECT_MAPPER.readValue(text, clazz);
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem deserializing from JSON", e);
        }
    }

    public static <T> List<T> readFromStringAsList(String text, Class<T> clazz) {
        try {
            CollectionType listType = PRETTY_OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, clazz);
            return (List)PRETTY_OBJECT_MAPPER.readValue(text, (JavaType)listType);
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem deserializing from JSON", e);
        }
    }

    public static void writeToFile(File file, Object object) {
        try {
            PRETTY_OBJECT_MAPPER.writeValue(file, object);
        }
        catch (IOException e) {
            throw new SmallToolsException("Problem serializing in JSON", e);
        }
    }

    public static void writeToFile(String fileName, Object object) {
        JsonTools.writeToFile(new File(fileName), object);
    }

    public static void writeToStream(OutputStream stream, Object object) {
        try {
            PRETTY_OBJECT_MAPPER.writeValue(stream, object);
        }
        catch (IOException e) {
            throw new SmallToolsException("Problem serializing in JSON", e);
        }
    }

    public static String writeToString(Object object) {
        try {
            return PRETTY_OBJECT_MAPPER.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new SmallToolsException("Problem serializing in JSON", e);
        }
    }

    private JsonTools() {
    }

    static {
        PRETTY_OBJECT_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        PRETTY_OBJECT_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        PRETTY_OBJECT_MAPPER.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
        PRETTY_SKIPNULL_OBJECT_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        PRETTY_SKIPNULL_OBJECT_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        PRETTY_SKIPNULL_OBJECT_MAPPER.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
        PRETTY_SKIPNULL_OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        COMPACT_OBJECT_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        COMPACT_OBJECT_MAPPER.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
        COMPACT_SKIPNULL_OBJECT_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        COMPACT_SKIPNULL_OBJECT_MAPPER.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
        COMPACT_SKIPNULL_OBJECT_MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        NON_FAIL_OBJECT_MAPPER.enable(SerializationFeature.INDENT_OUTPUT);
        NON_FAIL_OBJECT_MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        NON_FAIL_OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_IGNORED_PROPERTIES);
        NON_FAIL_OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES);
        NON_FAIL_OBJECT_MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        NON_FAIL_OBJECT_MAPPER.disable(new JsonGenerator.Feature[]{JsonGenerator.Feature.AUTO_CLOSE_TARGET});
    }
}

