/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.tools.CharsetTools;
import com.foilen.smalltools.tools.StreamsTools;

public final class ConsoleTools {
    public static int executeAndWait(String command) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(command);
            process.getOutputStream().close();
            StreamsTools.flowStreamNonBlocking(process.getInputStream(), System.out);
            StreamsTools.flowStreamNonBlocking(process.getErrorStream(), System.err);
            process.waitFor();
            return process.exitValue();
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public static int executeAndWait(String[] arguments) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(arguments);
            process.getOutputStream().close();
            StreamsTools.flowStreamNonBlocking(process.getInputStream(), System.out);
            StreamsTools.flowStreamNonBlocking(process.getErrorStream(), System.err);
            process.waitFor();
            return process.exitValue();
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    public static int executeAndWait(String[] arguments, String inputText) {
        Runtime runtime = Runtime.getRuntime();
        try {
            Process process = runtime.exec(arguments);
            StreamsTools.flowStreamNonBlocking(process.getInputStream(), System.out);
            StreamsTools.flowStreamNonBlocking(process.getErrorStream(), System.err);
            process.getOutputStream().write(inputText.getBytes(CharsetTools.UTF_8));
            process.getOutputStream().close();
            process.waitFor();
            return process.exitValue();
        }
        catch (Exception e) {
            throw new SmallToolsException(e);
        }
    }

    private ConsoleTools() {
    }
}

