/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public final class CollectionsTools {
    public static <T> Collector<T, ?, ArrayList<T>> collectToArrayList() {
        return Collectors.toCollection(ArrayList::new);
    }

    public static <K, V> V getOrCreateEmpty(Map<K, V> map, K key, Class<V> clazz) {
        V value = map.get(key);
        if (value == null) {
            try {
                value = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new SmallToolsException("Could not create the empty object", e);
            }
            map.put(key, value);
        }
        return value;
    }

    public static <K, V> List<V> getOrCreateEmptyArrayList(Map<K, List<V>> map, K key, Class<V> clazz) {
        return map.computeIfAbsent(key, k -> new ArrayList());
    }

    public static <K, V> Set<V> getOrCreateEmptyHashSet(Map<K, Set<V>> map, K key, Class<V> clazz) {
        return map.computeIfAbsent(key, k -> new HashSet());
    }

    public static <K, V extends Comparable<V>> Set<V> getOrCreateEmptyTreeSet(Map<K, Set<V>> map, K key, Class<V> clazz) {
        return map.computeIfAbsent(key, k -> new TreeSet());
    }

    public static boolean isAllItemNotNull(Collection<?> items) {
        for (Object item : items) {
            if (item != null) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllItemNotNull(Object ... items) {
        for (Object item : items) {
            if (item != null) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllItemNotNullOrEmpty(Collection<String> items) {
        for (String item : items) {
            if (item != null && !item.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isAllItemNotNullOrEmpty(String ... items) {
        for (String item : items) {
            if (item != null && !item.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isAnyItemNotNull(Collection<?> items) {
        for (Object item : items) {
            if (item == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyItemNotNull(Object ... items) {
        for (Object item : items) {
            if (item == null) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyItemNotNullOrEmpty(Collection<String> items) {
        for (String item : items) {
            if (item == null || item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyItemNotNullOrEmpty(String ... items) {
        for (String item : items) {
            if (item == null || item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static <K, V> K removeValue(Map<K, V> map, V valueToRemove) {
        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, V> entry = iterator.next();
            if (valueToRemove != entry.getValue()) continue;
            K key = entry.getKey();
            iterator.remove();
            return key;
        }
        return null;
    }

    public static <K, V> void removeValues(Map<K, V> map, V valueToRemove) {
        map.entrySet().removeIf(kvEntry -> valueToRemove == kvEntry.getValue());
    }

    public static <T> ArrayList<T> toArrayList(T[] array) {
        ArrayList<T> list = new ArrayList<T>(array.length);
        list.addAll(Arrays.asList(array));
        return list;
    }

    private CollectionsTools() {
    }
}

