/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.tools;

import com.foilen.smalltools.exception.SmallToolsException;

public final class AssertTools {
    public static void assertFalse(boolean actual) {
        AssertTools.assertFalse(actual, "Value must be false");
    }

    public static void assertFalse(boolean actual, String message) {
        if (actual) {
            throw new SmallToolsException(message);
        }
    }

    public static void assertNotNull(Object actual) {
        AssertTools.assertNotNull(actual, "Value must not be null");
    }

    public static void assertNotNull(Object actual, String message) {
        if (actual == null) {
            throw new SmallToolsException(message);
        }
    }

    public static void assertNull(Object actual) {
        AssertTools.assertNull(actual, "Value must be null");
    }

    public static void assertNull(Object actual, String message) {
        if (actual != null) {
            throw new SmallToolsException(message);
        }
    }

    public static void assertOnlyOneNotNull(String message, Object ... items) {
        int notNullCount = 0;
        for (Object item : items) {
            if (item != null && ++notNullCount > 1) break;
        }
        if (notNullCount != 1) {
            throw new SmallToolsException(message);
        }
    }

    public static void assertTrue(boolean actual) {
        AssertTools.assertTrue(actual, "Value must be true");
    }

    public static void assertTrue(boolean actual, String message) {
        if (!actual) {
            throw new SmallToolsException(message);
        }
    }

    private AssertTools() {
    }
}

