/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.test.asserts;

import com.foilen.smalltools.JavaEnvironmentValues;
import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.test.asserts.AssertDiff;
import com.foilen.smalltools.tools.CollectionsTools;
import com.foilen.smalltools.tools.DirectoryTools;
import com.foilen.smalltools.tools.FileTools;
import com.foilen.smalltools.tools.JsonTools;
import com.foilen.smalltools.tools.ResourceTools;
import com.foilen.smalltools.tools.SystemTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public final class AssertTools {
    public static void assertDiffJsonComparison(AssertDiff expected, List<?> initialItems, List<?> finalItems) {
        AssertTools.assertJsonComparison(expected, AssertTools.diffLists(initialItems, finalItems));
    }

    public static void assertDiffJsonComparison(String expectedResource, Class<?> expectedContext, List<?> initialItems, List<?> finalItems) {
        AssertTools.assertJsonComparison(expectedResource, expectedContext, AssertTools.diffLists(initialItems, finalItems));
    }

    public static void assertDiffJsonComparisonWithoutNulls(Object expected, List<?> initialItems, List<?> finalItems) {
        AssertTools.assertJsonComparisonWithoutNulls(expected, AssertTools.diffLists(initialItems, finalItems));
    }

    public static void assertDiffJsonComparisonWithoutNulls(String expectedResource, Class<?> expectedContext, List<?> initialItems, List<?> finalItems) {
        AssertTools.assertJsonComparisonWithoutNulls(expectedResource, expectedContext, AssertTools.diffLists(initialItems, finalItems));
    }

    public static void assertEqualsDelta(int expected, int actual, int delta) {
        if (Math.abs(expected - actual) > delta) {
            long expectedLow = expected - delta;
            long expectedHigh = expected + delta;
            Assert.fail((String)("Expecting value between " + expectedLow + " and " + expectedHigh + ", but got " + actual));
        }
    }

    public static void assertEqualsDelta(long expected, long actual, long delta) {
        if (Math.abs(expected - actual) > delta) {
            long expectedLow = expected - delta;
            long expectedHigh = expected + delta;
            Assert.fail((String)("Expecting value between " + expectedLow + " and " + expectedHigh + ", but got " + actual));
        }
    }

    public static void assertFileContent(File expectedFile, File actualFile) {
        Assert.assertEquals((long)expectedFile.length(), (long)actualFile.length());
        try {
            AssertTools.assertStreamContent(new FileInputStream(expectedFile), new FileInputStream(actualFile));
        }
        catch (FileNotFoundException e) {
            throw new SmallToolsException("Issue opening the files", e);
        }
    }

    public static void assertFileContent(InputStream expectedStream, String actualFile) {
        try {
            AssertTools.assertStreamContent(expectedStream, new FileInputStream(actualFile));
        }
        catch (FileNotFoundException e) {
            throw new SmallToolsException("Issue opening the file", e);
        }
    }

    public static void assertIgnoreLineFeed(String expected, String actual) {
        Assert.assertEquals((Object)expected.replaceAll("\r", ""), (Object)actual.replaceAll("\r", ""));
    }

    public static void assertJsonComparison(Object expected, Object actual) {
        String expectedJson = JsonTools.prettyPrint(expected);
        String actualJson = JsonTools.prettyPrint(actual);
        AssertTools.assertIgnoreLineFeed(expectedJson, actualJson);
    }

    public static void assertJsonComparison(String expectedResource, Class<?> expectedContext, Object actual) {
        String actualJson = JsonTools.prettyPrint(actual);
        if (AssertTools.updateFileIfRequested(expectedResource, expectedContext, actualJson)) {
            String expectedJson = ResourceTools.getResourceAsString(expectedResource, expectedContext);
            AssertTools.assertIgnoreLineFeed(expectedJson, actualJson);
        }
    }

    public static void assertJsonComparisonWithoutNulls(Object expected, Object actual) {
        String expectedJson = JsonTools.prettyPrintWithoutNulls(expected);
        String actualJson = JsonTools.prettyPrintWithoutNulls(actual);
        AssertTools.assertIgnoreLineFeed(expectedJson, actualJson);
    }

    public static void assertJsonComparisonWithoutNulls(String expectedResource, Class<?> expectedContext, Object actual) {
        String actualJson = JsonTools.prettyPrintWithoutNulls(actual);
        if (AssertTools.updateFileIfRequested(expectedResource, expectedContext, actualJson)) {
            String expectedJson = ResourceTools.getResourceAsString(expectedResource, expectedContext);
            AssertTools.assertIgnoreLineFeed(expectedJson, actualJson);
        }
    }

    public static void assertStreamContent(InputStream expectedStream, InputStream actualStream) {
        long position = 0L;
        try {
            int expectedLen;
            byte[] expectedBytes = new byte[1024];
            byte[] actualBytes = new byte[1024];
            do {
                expectedLen = expectedStream.read(expectedBytes);
                int actualLen = actualStream.read(actualBytes);
                Assert.assertEquals((long)expectedLen, (long)actualLen);
                Assert.assertArrayEquals((String)("Position: " + position), (byte[])expectedBytes, (byte[])actualBytes);
                position += (long)expectedLen;
            } while (expectedLen != -1);
        }
        catch (Exception e) {
            throw new SmallToolsException("Issue copying the stream", e);
        }
        finally {
            try {
                expectedStream.close();
            }
            catch (Exception exception) {}
            try {
                actualStream.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void assertYamlComparison(Object expected, Object actual) {
        DumperOptions dumperOptions = new DumperOptions();
        dumperOptions.setPrettyFlow(true);
        Yaml yaml = new Yaml(dumperOptions);
        String expectedYaml = yaml.dump(expected);
        String actualYaml = yaml.dump(actual);
        AssertTools.assertIgnoreLineFeed(expectedYaml, actualYaml);
    }

    public static void assertYamlComparison(String expectedResource, Class<?> expectedContext, Object actual) {
        Yaml yaml = new Yaml();
        Object expected = yaml.load(expectedContext.getResourceAsStream(expectedResource));
        AssertTools.assertYamlComparison(expected, actual);
    }

    private static AssertDiff diffLists(List<?> initialItems, List<?> finalItems) {
        int i;
        List initialJson = initialItems.stream().map(JsonTools::prettyPrint).collect(CollectionsTools.collectToArrayList());
        List finalJson = finalItems.stream().map(JsonTools::prettyPrint).collect(CollectionsTools.collectToArrayList());
        AssertDiff diff = new AssertDiff();
        for (i = 0; i < initialJson.size(); ++i) {
            String left = (String)initialJson.get(i);
            if (finalJson.contains(left)) continue;
            diff.getRemoved().add(initialItems.get(i));
        }
        for (i = 0; i < finalJson.size(); ++i) {
            String right = (String)finalJson.get(i);
            if (initialJson.contains(right)) continue;
            diff.getAdded().add(finalItems.get(i));
        }
        return diff;
    }

    private static boolean updateFileIfRequested(String expectedResource, Class<?> expectedContext, String actualJson) {
        String updateExpectedFileContains = SystemTools.getPropertyOrEnvironment("ASSERT_TOOLS_UPDATE_EXPECTED_FILE", "false");
        if (!"false".equals(updateExpectedFileContains)) {
            URL url = expectedContext.getResource(expectedResource);
            if (url == null) {
                Assert.fail((String)"The file must already exists (you can create an empty file)");
            } else {
                String filename = url.toString().substring(5);
                String filePart = new File(filename).getName();
                List<String> availableFiles = DirectoryTools.listFilesAndFoldersRecursively(JavaEnvironmentValues.getWorkingDirectory(), true).stream().filter(it -> it.endsWith(filePart) && !it.equals(filename)).filter(it -> it.contains(updateExpectedFileContains)).collect(Collectors.toList());
                if (availableFiles.isEmpty()) {
                    Assert.fail((String)("No file found for " + filePart));
                }
                if (availableFiles.size() > 1) {
                    System.out.println("Too many files found for " + filePart + ":");
                    availableFiles.forEach(System.out::println);
                    System.out.println("You can configure ASSERT_TOOLS_UPDATE_EXPECTED_FILE to filter the path containing that value");
                    Assert.fail((String)("Too many files found for " + filePart));
                }
                String fileToUpdate = (String)availableFiles.get(0);
                System.out.println("Updating " + fileToUpdate);
                FileTools.writeFile(actualJson, fileToUpdate);
            }
            return false;
        }
        return true;
    }

    private AssertTools() {
    }
}

