/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.systemusage;

import com.foilen.smalltools.JavaEnvironmentValues;
import com.foilen.smalltools.systemusage.implementations.MemoryUsageOsMxImpl;
import com.foilen.smalltools.systemusage.implementations.MemoryUsageProcImpl;
import com.foilen.smalltools.systemusage.implementations.MemoryUsageStrategy;

public class MemoryUsage {
    private static MemoryUsageStrategy memoryUsageStrategy;

    public static Long getSystemFreeMemory() {
        return memoryUsageStrategy.getSystemFreeMemory();
    }

    public static Double getSystemFreeMemoryPercent() {
        Long free = MemoryUsage.getSystemFreeMemory();
        Long total = MemoryUsage.getSystemTotalMemory();
        if (free == null || total == null || total == 0L) {
            return null;
        }
        return (double)free.longValue() * 100.0 / (double)total.longValue();
    }

    public static Long getSystemTotalMemory() {
        return memoryUsageStrategy.getSystemTotalMemory();
    }

    public static Long getSystemUsedMemory() {
        return memoryUsageStrategy.getSystemUsedMemory();
    }

    public static Double getSystemUsedMemoryPercent() {
        Double freePercent = MemoryUsage.getSystemFreeMemoryPercent();
        if (freePercent == null) {
            return null;
        }
        return 100.0 - freePercent;
    }

    public static void main(String[] args) {
        System.out.println("getSystemFreeMemory: " + MemoryUsage.getSystemFreeMemory() + " " + MemoryUsage.getSystemFreeMemoryPercent() + "%");
        System.out.println("getSystemUsedMemory: " + MemoryUsage.getSystemUsedMemory() + " " + MemoryUsage.getSystemUsedMemoryPercent() + "%");
        System.out.println("getSystemTotalMemory: " + MemoryUsage.getSystemTotalMemory());
    }

    static {
        if (JavaEnvironmentValues.getJavaClassVersion() <= 52) {
            memoryUsageStrategy = new MemoryUsageOsMxImpl();
        } else if (JavaEnvironmentValues.getOperatingSystem().toLowerCase().startsWith("linux")) {
            memoryUsageStrategy = new MemoryUsageProcImpl();
        }
    }
}

