/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.shell;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.shell.ExecResult;
import com.foilen.smalltools.tools.FileTools;
import com.foilen.smalltools.tools.StreamsTools;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.stream.Stream;

public class ExecResultInFiles
implements ExecResult {
    private File out;
    private File err;
    private int exitCode;

    public ExecResultInFiles(File out, File err, int exitCode) {
        this.out = out;
        this.err = err;
        this.exitCode = exitCode;
    }

    public File getErr() {
        return this.err;
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    public File getOut() {
        return this.out;
    }

    @Override
    public InputStream getStdErrAsInputStream() {
        try {
            return new FileInputStream(this.err);
        }
        catch (FileNotFoundException e) {
            throw new SmallToolsException(e);
        }
    }

    @Override
    public Stream<String> getStdErrAsLines() {
        return FileTools.readFileLinesStream(this.err);
    }

    @Override
    public String getStdErrAsString() {
        return StreamsTools.consumeAsString(this.getStdErrAsInputStream());
    }

    @Override
    public InputStream getStdOutAsInputStream() {
        try {
            return new FileInputStream(this.out);
        }
        catch (FileNotFoundException e) {
            throw new SmallToolsException(e);
        }
    }

    @Override
    public Stream<String> getStdOutAsLines() {
        return FileTools.readFileLinesStream(this.out);
    }

    @Override
    public String getStdOutAsString() {
        return StreamsTools.consumeAsString(this.getStdOutAsInputStream());
    }
}

