/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.math;

public class Vector2f {
    public float x;
    public float y;

    public Vector2f() {
    }

    public Vector2f(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public Vector2f(Vector2f vector) {
        this.set(vector);
    }

    public Vector2f addLocal(Vector2f add) {
        this.x += add.x;
        this.y += add.y;
        return this;
    }

    public Vector2f divideLocal(float div) {
        this.x /= div;
        this.y /= div;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f;
    }

    public float length() {
        return (float)Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vector2f multLocal(float mult) {
        this.x *= mult;
        this.y *= mult;
        return this;
    }

    public void normalize() {
        if (!this.isZero()) {
            this.divideLocal(this.length());
        }
    }

    public void set(Vector2f vector) {
        this.x = vector.x;
        this.y = vector.y;
    }

    public void setX(float x) {
        this.x = x;
    }

    public void setY(float y) {
        this.y = y;
    }

    public Vector2f subLocal(Vector2f other) {
        this.x -= other.x;
        this.y -= other.y;
        return this;
    }

    public String toString() {
        return "(" + this.x + ", " + this.y + ")";
    }
}

