/*
 * Decompiled with CFR 0.152.
 */
package com.foilen.smalltools.hash;

import com.foilen.smalltools.exception.SmallToolsException;
import com.foilen.smalltools.hash.HashUtils;
import com.foilen.smalltools.tools.CharsetTools;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;

public final class HashSha1 {
    private static final String ALGORITHM = "SHA-1";

    public static String hashBytes(byte[] in) {
        return HashUtils.hashInputStream(ALGORITHM, new ByteArrayInputStream(in));
    }

    public static String hashFile(File file) {
        try {
            return HashUtils.hashInputStream(ALGORITHM, new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw new SmallToolsException(e);
        }
    }

    public static String hashFile(String filePath) {
        return HashSha1.hashFile(new File(filePath));
    }

    public static String hashString(String in) {
        return HashUtils.hashInputStream(ALGORITHM, new ByteArrayInputStream(in.getBytes(CharsetTools.UTF_8)));
    }

    private HashSha1() {
    }
}

